/*
  +----------------------------------------------------------------------+
  | PHP Version 5                                                        |
  +----------------------------------------------------------------------+
  | Copyright (c) 1999-2004 The PHP Group                                |
  +----------------------------------------------------------------------+
  | This source file is subject to version 3.0 of the PHP license,       |
  | that is bundled with this package in the file LICENSE, and is        |
  | available at through the world-wide-web at                           |
  | http://www.php.net/license/3_0.txt.                                  |
  | If you did not receive a copy of the PHP license and are unable to   |
  | obtain it through the world-wide-web, please send a note to          |
  | license@php.net so we can mail you a copy immediately.               |
  +----------------------------------------------------------------------+
  | Authors: Mathieu Hurtevent <ut0pia@users.sourceforge.net>            |
  +----------------------------------------------------------------------+
*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "php.h"
#include "php_ini.h"
#include "ext/standard/info.h"

#include "php_tk.h"

/*
#if HAVE_PTHREAD_LIB
*/

#include <pthread.h>
#include <signal.h>

#include <unistd.h>

/* {{{ ???
 /
static int le_tk;
static int le_tk_bitmap;
static int le_tk_button;
static int le_tk_canvas;
static int le_tk_checkbutton;
static int le_tk_entry;
static int le_tk_font;
static int le_tk_frame;
static int le_tk_label;
static int le_tk_labelframe;
static int le_tk_listbox;
static int le_tk_menu;
static int le_tk_menubutton;
static int le_tk_message;
static int le_tk_panedwindow;
static int le_tk_photo;
static int le_tk_radiobutton;
static int le_tk_scale;
static int le_tk_scrollbar;
static int le_tk_spinbox;
static int le_tk_text;
static int le_tk_textcopy;
static int le_tk_textcut;
static int le_tk_textpaste;
static int le_tk_toplevel;
* }}} */


/* {{{ Class declarations
 */
static zend_class_entry *php_tk_ce_ptr;
static zend_class_entry *php_tk_bitmap_ce_ptr;
static zend_class_entry *php_tk_button_ce_ptr;
static zend_class_entry *php_tk_canvas_ce_ptr;
static zend_class_entry *php_tk_checkbutton_ce_ptr;
static zend_class_entry *php_tk_entry_ce_ptr;
static zend_class_entry *php_tk_font_ce_ptr;
static zend_class_entry *php_tk_frame_ce_ptr;
static zend_class_entry *php_tk_label_ce_ptr;
static zend_class_entry *php_tk_labelframe_ce_ptr;
static zend_class_entry *php_tk_listbox_ce_ptr;
static zend_class_entry *php_tk_menu_ce_ptr;
static zend_class_entry *php_tk_menubutton_ce_ptr;
static zend_class_entry *php_tk_message_ce_ptr;
static zend_class_entry *php_tk_panedwindow_ce_ptr;
static zend_class_entry *php_tk_photo_ce_ptr;
static zend_class_entry *php_tk_radiobutton_ce_ptr;
static zend_class_entry *php_tk_scale_ce_ptr;
static zend_class_entry *php_tk_scrollbar_ce_ptr;
static zend_class_entry *php_tk_spinbox_ce_ptr;
static zend_class_entry *php_tk_text_ce_ptr;
static zend_class_entry *php_tk_textcopy_ce_ptr;
static zend_class_entry *php_tk_textcut_ce_ptr;
static zend_class_entry *php_tk_textpaste_ce_ptr;
static zend_class_entry *php_tk_toplevel_ce_ptr;
/* }}} */

zend_function_entry tk_functions[] =
{
	PHP_FALIAS(tk_mainloop, za_tk_mainloop, NULL)
	PHP_FALIAS(tk_exit, za_tk_exit, NULL)
	PHP_FALIAS(tk_callback, za_tk_callback, NULL)
	PHP_FALIAS(tk_debug, za_tk_debug, NULL)
	PHP_FALIAS(tk_shell, za_tk_shell, NULL)
	
	PHP_FALIAS(tk_addslashes, za_tk_addslashes, NULL)
	PHP_FALIAS(tcl_listtoarray, za_tcl_listtoarray, NULL)
	
	PHP_FALIAS(tk_appname, za_tk_appname, NULL)
	PHP_FALIAS(tk_bisque, za_tk_bisque, NULL)
	PHP_FALIAS(tk_choosecolor, za_tk_choosecolor, NULL)
	PHP_FALIAS(tk_choosedirectory, za_tk_choosedirectory, NULL)
	PHP_FALIAS(tk_dialog, za_tk_dialog, NULL)
	PHP_FALIAS(tk_eventadd, za_tk_eventadd, NULL)
	PHP_FALIAS(tk_eventdelete, za_tk_eventdelete, NULL)
	PHP_FALIAS(tk_eventgenerate, za_tk_eventgenerate, NULL)
	PHP_FALIAS(tk_eventinfo, za_tk_eventinfo, NULL)
	PHP_FALIAS(tk_focusfollowsmouse, za_tk_focusfollowsmouse, NULL)
	PHP_FALIAS(tk_focusnext, za_tk_focusnext, NULL)
	PHP_FALIAS(tk_focusprev, za_tk_focusprev, NULL)
	PHP_FALIAS(tk_fontfamilies, za_tk_fontfamilies, NULL)
	PHP_FALIAS(tk_fontnames, za_tk_fontnames, NULL)
	PHP_FALIAS(tk_getopenfile, za_tk_getopenfile, NULL)
	PHP_FALIAS(tk_getsavefile, za_tk_getsavefile, NULL)
	PHP_FALIAS(tk_imagenames, za_tk_imagenames, NULL)
	PHP_FALIAS(tk_imagetypes, za_tk_imagetypes, NULL)
	PHP_FALIAS(tk_messagebox, za_tk_messagebox, NULL)
	PHP_FALIAS(tk_optionadd, za_tk_optionadd, NULL)
	PHP_FALIAS(tk_optionclear, za_tk_optionclear, NULL)
	PHP_FALIAS(tk_optionget, za_tk_optionget, NULL)
	PHP_FALIAS(tk_optionmenu, za_tk_optionmenu, NULL)
	PHP_FALIAS(tk_optionreadfile, za_tk_optionreadfile, NULL)
	PHP_FALIAS(tk_popup, za_tk_popup, NULL)
	PHP_FALIAS(tk_scaling, za_tk_scaling, NULL)
	PHP_FALIAS(tk_selectionclear, za_tk_selectionclear, NULL)
	PHP_FALIAS(tk_selectionget, za_tk_selectionget, NULL)
	PHP_FALIAS(tk_selectionhandle, za_tk_selectionhandle, NULL)
	PHP_FALIAS(tk_selectionown, za_tk_selectionown, NULL)
	PHP_FALIAS(tk_send, za_tk_send, NULL)
	PHP_FALIAS(tk_setpalette, za_tk_setpalette, NULL)
	PHP_FALIAS(tk_useinputmethods, za_tk_useinputmethods, NULL)
	{NULL, NULL, NULL}
};

function_entry bitmap_functions[] = {
	PHP_FALIAS(bitmap, za_bitmap, NULL)
	PHP_FALIAS(delete, im_delete, NULL)
	PHP_FALIAS(height, im_height, NULL)
	PHP_FALIAS(inuse, im_inuse, NULL)
	PHP_FALIAS(type, im_type, NULL)
	PHP_FALIAS(width, im_width, NULL)
	PHP_FALIAS(cget, za_cget, NULL)
	PHP_FALIAS(configure, za_configure, NULL)
	{NULL, NULL, NULL}
};

function_entry photo_functions[] = {
	PHP_FALIAS(photo, za_photo, NULL)
	PHP_FALIAS(delete, im_delete, NULL)
	PHP_FALIAS(height, im_height, NULL)
	PHP_FALIAS(inuse, im_inuse, NULL)
	PHP_FALIAS(type, im_type, NULL)
	PHP_FALIAS(width, im_width, NULL)
	PHP_FALIAS(cget, za_cget, NULL)
	PHP_FALIAS(configure, za_configure, NULL)
	PHP_FALIAS(blank, za_blank, NULL)
	PHP_FALIAS(copy, za_copy, NULL)
	PHP_FALIAS(data, za_data, NULL)
	PHP_FALIAS(get, za_get, NULL)
	PHP_FALIAS(put, za_put, NULL)
	PHP_FALIAS(read, za_read, NULL)
	PHP_FALIAS(redither, za_redither, NULL)
	PHP_FALIAS(transparencyget, za_transparencyget, NULL)
	PHP_FALIAS(transparencyset, za_transparencyset, NULL)
	PHP_FALIAS(write, za_write, NULL)
	{NULL, NULL, NULL}
};

function_entry font_functions[] = {
	PHP_FALIAS(font, za_font, NULL)
	PHP_FALIAS(actual, ft_actual, NULL)
	PHP_FALIAS(configure, ft_configure, NULL)
	PHP_FALIAS(delete, ft_delete, NULL)
	PHP_FALIAS(measure, ft_measure, NULL)
	PHP_FALIAS(metrics, ft_metrics, NULL)
	{NULL, NULL, NULL}
};

function_entry scale_functions[] = {
	PHP_FALIAS(scale, sc_scale, NULL)
	PHP_FALIAS(cget, za_cget, NULL)
	PHP_FALIAS(configure, za_configure, NULL)
	PHP_FALIAS(coords, za_coords, NULL)
	PHP_FALIAS(get, za_get, NULL)
	PHP_FALIAS(identify, za_identify, NULL)
	PHP_FALIAS(set, za_set, NULL)
	{NULL, NULL, NULL}
};

function_entry oO_functions[] = {
	PHP_FALIAS(tk, za_tk, NULL)
	PHP_FALIAS(getid, za_getid, NULL)
	
	/* {{{ generate oO_functions code */
	PHP_FALIAS(button, za_button, NULL)
	PHP_FALIAS(canvas, za_canvas, NULL)
	PHP_FALIAS(checkbutton, za_checkbutton, NULL)
	PHP_FALIAS(entry, za_entry, NULL)
	PHP_FALIAS(frame, za_frame, NULL)
	PHP_FALIAS(label, za_label, NULL)
	PHP_FALIAS(labelframe, za_labelframe, NULL)
	PHP_FALIAS(listbox, za_listbox, NULL)
	PHP_FALIAS(menu, za_menu, NULL)
	PHP_FALIAS(menubutton, za_menubutton, NULL)
	PHP_FALIAS(message, za_message, NULL)
	PHP_FALIAS(panedwindow, za_panedwindow, NULL)
	PHP_FALIAS(radiobutton, za_radiobutton, NULL)
	PHP_FALIAS(scrollbar, za_scrollbar, NULL)
	PHP_FALIAS(spinbox, za_spinbox, NULL)
	PHP_FALIAS(text, za_text, NULL)
	PHP_FALIAS(textcopy, za_textcopy, NULL)
	PHP_FALIAS(textcut, za_textcut, NULL)
	PHP_FALIAS(textpaste, za_textpaste, NULL)
	PHP_FALIAS(toplevel, za_toplevel, NULL)
	PHP_FALIAS(activate, za_activate, NULL)
	PHP_FALIAS(add, za_add, NULL)
	PHP_FALIAS(addtag, za_addtag, NULL)
	PHP_FALIAS(bbox, za_bbox, NULL)
	PHP_FALIAS(bell, za_bell, NULL)
	PHP_FALIAS(bind, za_bind, NULL)
	PHP_FALIAS(bindtags, za_bindtags, NULL)
	PHP_FALIAS(canvasx, za_canvasx, NULL)
	PHP_FALIAS(canvasy, za_canvasy, NULL)
	PHP_FALIAS(cget, za_cget, NULL)
	PHP_FALIAS(clipboardappend, za_clipboardappend, NULL)
	PHP_FALIAS(clipboardclear, za_clipboardclear, NULL)
	PHP_FALIAS(clipboardget, za_clipboardget, NULL)
	PHP_FALIAS(clone, za_clone, NULL)
	PHP_FALIAS(compare, za_compare, NULL)
	PHP_FALIAS(configure, za_configure, NULL)
	PHP_FALIAS(coords, za_coords, NULL)
	PHP_FALIAS(count, za_count, NULL)
	PHP_FALIAS(create, za_create, NULL)
	PHP_FALIAS(curselection, za_curselection, NULL)
	PHP_FALIAS(dchars, za_dchars, NULL)
	PHP_FALIAS(debug, za_debug, NULL)
	PHP_FALIAS(delete, za_delete, NULL)
	PHP_FALIAS(delta, za_delta, NULL)
	PHP_FALIAS(deselect, za_deselect, NULL)
	PHP_FALIAS(destroy, za_destroy, NULL)
	PHP_FALIAS(dlineinfo, za_dlineinfo, NULL)
	PHP_FALIAS(dtag, za_dtag, NULL)
	PHP_FALIAS(dump, za_dump, NULL)
	PHP_FALIAS(editmodified, za_editmodified, NULL)
	PHP_FALIAS(editredo, za_editredo, NULL)
	PHP_FALIAS(editreset, za_editreset, NULL)
	PHP_FALIAS(editseparator, za_editseparator, NULL)
	PHP_FALIAS(editundo, za_editundo, NULL)
	PHP_FALIAS(entrycget, za_entrycget, NULL)
	PHP_FALIAS(entryconfigure, za_entryconfigure, NULL)
	PHP_FALIAS(find, za_find, NULL)
	PHP_FALIAS(flash, za_flash, NULL)
	PHP_FALIAS(focus, za_focus, NULL)
	PHP_FALIAS(forget, za_forget, NULL)
	PHP_FALIAS(fraction, za_fraction, NULL)
	PHP_FALIAS(get, za_get, NULL)
	PHP_FALIAS(gettags, za_gettags, NULL)
	PHP_FALIAS(grab, za_grab, NULL)
	PHP_FALIAS(grabcurrent, za_grabcurrent, NULL)
	PHP_FALIAS(grabrelease, za_grabrelease, NULL)
	PHP_FALIAS(grabset, za_grabset, NULL)
	PHP_FALIAS(grabstatut, za_grabstatut, NULL)
	PHP_FALIAS(grid, za_grid, NULL)
	PHP_FALIAS(gridanchor, za_gridanchor, NULL)
	PHP_FALIAS(gridbbox, za_gridbbox, NULL)
	PHP_FALIAS(gridcolumnconfigure, za_gridcolumnconfigure, NULL)
	PHP_FALIAS(gridconfigure, za_gridconfigure, NULL)
	PHP_FALIAS(gridforget, za_gridforget, NULL)
	PHP_FALIAS(gridinfo, za_gridinfo, NULL)
	PHP_FALIAS(gridlocation, za_gridlocation, NULL)
	PHP_FALIAS(gridpropagate, za_gridpropagate, NULL)
	PHP_FALIAS(gridremove, za_gridremove, NULL)
	PHP_FALIAS(gridrowconfigure, za_gridrowconfigure, NULL)
	PHP_FALIAS(gridsize, za_gridsize, NULL)
	PHP_FALIAS(gridslaves, za_gridslaves, NULL)
	PHP_FALIAS(icursor, za_icursor, NULL)
	PHP_FALIAS(identify, za_identify, NULL)
	PHP_FALIAS(imagecget, za_imagecget, NULL)
	PHP_FALIAS(imageconfigure, za_imageconfigure, NULL)
	PHP_FALIAS(imagecreate, za_imagecreate, NULL)
	PHP_FALIAS(imagenames, za_imagenames, NULL)
	PHP_FALIAS(index, za_index, NULL)
	PHP_FALIAS(insert, za_insert, NULL)
	PHP_FALIAS(invoke, za_invoke, NULL)
	PHP_FALIAS(itemcget, za_itemcget, NULL)
	PHP_FALIAS(itemconfigure, za_itemconfigure, NULL)
	PHP_FALIAS(lower, za_lower, NULL)
	PHP_FALIAS(markgravity, za_markgravity, NULL)
	PHP_FALIAS(marknames, za_marknames, NULL)
	PHP_FALIAS(marknext, za_marknext, NULL)
	PHP_FALIAS(markprevious, za_markprevious, NULL)
	PHP_FALIAS(markset, za_markset, NULL)
	PHP_FALIAS(markunset, za_markunset, NULL)
	PHP_FALIAS(move, za_move, NULL)
	PHP_FALIAS(nearest, za_nearest, NULL)
	PHP_FALIAS(pack, za_pack, NULL)
	PHP_FALIAS(packconfigure, za_packconfigure, NULL)
	PHP_FALIAS(packforget, za_packforget, NULL)
	PHP_FALIAS(packinfo, za_packinfo, NULL)
	PHP_FALIAS(packpropagate, za_packpropagate, NULL)
	PHP_FALIAS(packslaves, za_packslaves, NULL)
	PHP_FALIAS(panecget, za_panecget, NULL)
	PHP_FALIAS(paneconfigure, za_paneconfigure, NULL)
	PHP_FALIAS(panes, za_panes, NULL)
	PHP_FALIAS(place, za_place, NULL)
	PHP_FALIAS(placeconfigure, za_placeconfigure, NULL)
	PHP_FALIAS(placeforget, za_placeforget, NULL)
	PHP_FALIAS(placeinfo, za_placeinfo, NULL)
	PHP_FALIAS(placeslaves, za_placeslaves, NULL)
	PHP_FALIAS(post, za_post, NULL)
	PHP_FALIAS(postcascade, za_postcascade, NULL)
	PHP_FALIAS(postscript, za_postscript, NULL)
	PHP_FALIAS(proxy, za_proxy, NULL)
	PHP_FALIAS(proxycoord, za_proxycoord, NULL)
	PHP_FALIAS(proxyforget, za_proxyforget, NULL)
	PHP_FALIAS(proxyplace, za_proxyplace, NULL)
	PHP_FALIAS(raise, za_raise, NULL)
	PHP_FALIAS(replace, za_replace, NULL)
	PHP_FALIAS(sash, za_sash, NULL)
	PHP_FALIAS(sashcoord, za_sashcoord, NULL)
	PHP_FALIAS(sashmark, za_sashmark, NULL)
	PHP_FALIAS(sashplace, za_sashplace, NULL)
	PHP_FALIAS(scale, za_scale, NULL)
	PHP_FALIAS(scandragto, za_scandragto, NULL)
	PHP_FALIAS(scanmark, za_scanmark, NULL)
	PHP_FALIAS(search, za_search, NULL)
	PHP_FALIAS(see, za_see, NULL)
	PHP_FALIAS(selectadjust, za_selectadjust, NULL)
	PHP_FALIAS(selectclear, za_selectclear, NULL)
	PHP_FALIAS(selectfrom, za_selectfrom, NULL)
	PHP_FALIAS(selectitem, za_selectitem, NULL)
	PHP_FALIAS(selectto, za_selectto, NULL)
	PHP_FALIAS(selectionadjust, za_selectionadjust, NULL)
	PHP_FALIAS(selectionanchor, za_selectionanchor, NULL)
	PHP_FALIAS(selectionclear, za_selectionclear, NULL)
	PHP_FALIAS(selectionelement, za_selectionelement, NULL)
	PHP_FALIAS(selectionfrom, za_selectionfrom, NULL)
	PHP_FALIAS(selectionincludes, za_selectionincludes, NULL)
	PHP_FALIAS(selectionpresent, za_selectionpresent, NULL)
	PHP_FALIAS(selectionrange, za_selectionrange, NULL)
	PHP_FALIAS(selectionset, za_selectionset, NULL)
	PHP_FALIAS(selectionto, za_selectionto, NULL)
	PHP_FALIAS(set, za_set, NULL)
	PHP_FALIAS(size, za_size, NULL)
	PHP_FALIAS(tagadd, za_tagadd, NULL)
	PHP_FALIAS(tagbind, za_tagbind, NULL)
	PHP_FALIAS(tagcget, za_tagcget, NULL)
	PHP_FALIAS(tagconfigure, za_tagconfigure, NULL)
	PHP_FALIAS(tagdelete, za_tagdelete, NULL)
	PHP_FALIAS(taglower, za_taglower, NULL)
	PHP_FALIAS(tagnames, za_tagnames, NULL)
	PHP_FALIAS(tagnextrange, za_tagnextrange, NULL)
	PHP_FALIAS(tagprevrange, za_tagprevrange, NULL)
	PHP_FALIAS(tagraise, za_tagraise, NULL)
	PHP_FALIAS(tagranges, za_tagranges, NULL)
	PHP_FALIAS(tagremove, za_tagremove, NULL)
	PHP_FALIAS(toggle, za_toggle, NULL)
	PHP_FALIAS(type, za_type, NULL)
	PHP_FALIAS(unpost, za_unpost, NULL)
	PHP_FALIAS(validate, za_validate, NULL)
	PHP_FALIAS(windowcget, za_windowcget, NULL)
	PHP_FALIAS(windowconfigure, za_windowconfigure, NULL)
	PHP_FALIAS(windowcreate, za_windowcreate, NULL)
	PHP_FALIAS(windownames, za_windownames, NULL)
	PHP_FALIAS(wmaspect, za_wmaspect, NULL)
	PHP_FALIAS(wmattributes, za_wmattributes, NULL)
	PHP_FALIAS(wmclient, za_wmclient, NULL)
	PHP_FALIAS(wmcolormapwindows, za_wmcolormapwindows, NULL)
	PHP_FALIAS(wmcommand, za_wmcommand, NULL)
	PHP_FALIAS(wmdeiconify, za_wmdeiconify, NULL)
	PHP_FALIAS(wmfocusmodel, za_wmfocusmodel, NULL)
	PHP_FALIAS(wmframe, za_wmframe, NULL)
	PHP_FALIAS(wmgeometry, za_wmgeometry, NULL)
	PHP_FALIAS(wmgrid, za_wmgrid, NULL)
	PHP_FALIAS(wmgroup, za_wmgroup, NULL)
	PHP_FALIAS(wmiconbitmap, za_wmiconbitmap, NULL)
	PHP_FALIAS(wmiconify, za_wmiconify, NULL)
	PHP_FALIAS(wmiconmask, za_wmiconmask, NULL)
	PHP_FALIAS(wmiconname, za_wmiconname, NULL)
	PHP_FALIAS(wmiconposition, za_wmiconposition, NULL)
	PHP_FALIAS(wmiconwindow, za_wmiconwindow, NULL)
	PHP_FALIAS(wmmaxsize, za_wmmaxsize, NULL)
	PHP_FALIAS(wmminsize, za_wmminsize, NULL)
	PHP_FALIAS(wmoverrideredirect, za_wmoverrideredirect, NULL)
	PHP_FALIAS(wmpositionfrom, za_wmpositionfrom, NULL)
	PHP_FALIAS(wmprotocol, za_wmprotocol, NULL)
	PHP_FALIAS(wmresizable, za_wmresizable, NULL)
	PHP_FALIAS(wmsizefrom, za_wmsizefrom, NULL)
	PHP_FALIAS(wmstackorder, za_wmstackorder, NULL)
	PHP_FALIAS(wmstate, za_wmstate, NULL)
	PHP_FALIAS(wmtitle, za_wmtitle, NULL)
	PHP_FALIAS(wmtransient, za_wmtransient, NULL)
	PHP_FALIAS(wmwithdraw, za_wmwithdraw, NULL)
	PHP_FALIAS(xview, za_xview, NULL)
	PHP_FALIAS(xviewmoveto, za_xviewmoveto, NULL)
	PHP_FALIAS(xviewscroll, za_xviewscroll, NULL)
	PHP_FALIAS(yposition, za_yposition, NULL)
	PHP_FALIAS(yview, za_yview, NULL)
	PHP_FALIAS(yviewmoveto, za_yviewmoveto, NULL)
	PHP_FALIAS(yviewscroll, za_yviewscroll, NULL)
	/* }}} */
	{NULL, NULL, NULL}
};

zend_module_entry tk_module_entry =
{
#if ZEND_MODULE_API_NO >= 20010901
	STANDARD_MODULE_HEADER,
#endif
	"PHP_TK",
	tk_functions,
	PHP_MINIT(php_tk), 
	PHP_MSHUTDOWN(php_tk), 
	NULL, 
	PHP_RSHUTDOWN(php_tk), 
	PHP_MINFO(php_tk),
#if ZEND_MODULE_API_NO >= 20010901
	"0.1.1",
#endif
	STANDARD_MODULE_PROPERTIES
};


#if COMPILE_DL_TK
ZEND_GET_MODULE(tk)
#endif


/* {{{ C STANDARD FUNCTIONS
 */

/* {{{ php_destroy_tk_resource
 * 	??? I do not know for what that is used (Mathieu)
 *
static void php_destroy_tk_resource(zend_rsrc_list_entry *resource TSRMLS_DC) {
	;
}
* }}} */


/* {{{ php_tk_new_widget
 *	create a new widget
 */
static void php_tk_new_widget(INTERNAL_FUNCTION_PARAMETERS, PARAM_TK_CMD) {
	int i = 1, z_argc = ZEND_NUM_ARGS();

	zval **param_widget_id;
	zval **z_args[z_argc];
	
	char *tk_shell = emalloc(sizeof(char)*64);
	
	if (z_argc > 0)
		if (zend_get_parameters_array_ex 
			(z_argc, z_args) == FAILURE) 
		{
			WRONG_PARAM_COUNT; 
		}
	/*
	 * la cration d'un widget necessite un objet conteneur en premier argument
	 */
	char new_widget_id[32];
	
	if (z_argc < 1 || (*z_args[0])->type != IS_OBJECT) 
	{
		i--;
		
		sprintf(new_widget_id, ".%d", ++php_tk->widget_assign);
		sprintf(tk_shell, "%s %s", TK_CMD, new_widget_id);
	}
	else 
	{
		if (zend_hash_find(Z_OBJPROP_P((*z_args[0]) TSRMLS_CC), "id", 
			sizeof ("id"), (void **)&param_widget_id) == FAILURE) 
		{
			zend_error(E_ERROR, "invalid object"); 
		}

		char *cont_widget_id = (*param_widget_id)->value.str.len != 1
			? (*param_widget_id)->value.str.val:"";
			
		sprintf(new_widget_id, "%s.%d", cont_widget_id, ++php_tk->widget_assign);
		sprintf(tk_shell, "%s %s", TK_CMD, new_widget_id);	
	}

	add_property_string(getThis(), "id", new_widget_id, sizeof (new_widget_id));


	for (; i < z_argc; i++) {
		if ((*z_args[i])->type != IS_OBJECT) {
			
			tk_shell = erealloc (tk_shell, sizeof(char)*(strlen(tk_shell) 
				+ (*z_args[i])->value.str.len+2));
			
			sprintf (tk_shell, "%s %s", tk_shell, (*z_args[i])->value.str.val);
		} 
		else 
		{
			zval **z_object_id;
			/* 
			 * Valeur de type objet, si celui ci est de type "widget", on rcupre son nom
			 * avec la variable $_WidgetID, et on l'ajoute dans la ligne de commande.
			 */
			if (zend_hash_find(Z_OBJPROP_P((*z_args[i]) TSRMLS_CC), 
				"id", sizeof ("id"), (void **)&z_object_id) != FAILURE) 
			{
				tk_shell = erealloc (tk_shell, sizeof(char)*(strlen(tk_shell)
					+ (*z_object_id)->value.str.len+2));
				
				sprintf (tk_shell, "%s %s", tk_shell, (*z_object_id)->value.str.val); 
			}
		}
	}

	php_tk_terminal(return_value, tk_shell, RETURN_WIDGET);
}
/* }}} */

/* {{{ php_tk_widget_command
 * 	execute an command for a widget concerned
 */
static void php_tk_widget_command(INTERNAL_FUNCTION_PARAMETERS, PARAM_TK_CMD, PARAM_TK_TYPE, PARAM_TK_RETURN) {
	int z_argc = ZEND_NUM_ARGS();
	zval **z_widget_id, **z_args[z_argc], **z_object_id, **z_val;
	HashPosition z_hp;

	if (z_argc > 0)
		if (zend_get_parameters_array_ex (z_argc, z_args) 
			== FAILURE)
				WRONG_PARAM_COUNT;
	
	/*
	 * On rcupre le contenu de la variable $z_widget_id de cet Objet, 
	 * celle-ci contient le nom du widget...
	 */
	if (zend_hash_find(Z_OBJPROP_P(getThis() TSRMLS_CC), "id", sizeof ("id"), 
		(void **)&z_widget_id) == FAILURE)
	{
		zend_error(E_ERROR, "invalid object");
	}
	/**/
			
	char *tk_shell = emalloc (sizeof (char) * 64);
			
	/*
	 * On switche maintenant sur la macro TK_TYPE (=PARAM_TK_TYPE).
	 * GLOBAL_TK: la commande doit tre marqu AVANT le nom du widget.(exemple configure [widget_name] ...)
	 * LOCAL_TK: la commande doit tre marqu APRS le nom du widget. (exemple[widget_name] cget ...)
	 */
	if (TK_TYPE != GLOBAL_TK)
		sprintf (tk_shell, "%s %s", (*z_widget_id)->value.str.val, TK_CMD);
	else 
		sprintf (tk_shell, "%s %s", TK_CMD, (*z_widget_id)->value.str.val);
	
	/*
	 * On fait maintenant une boucle sur le tableau contenant les arguments
	 * en vrifiant pour chacune des valeurs, quel est son type.
	 */
	int i;for (i = 0; i < z_argc; i++) 
	{
		switch ((*z_args[i])->type) 
		{
			
			case IS_OBJECT:
				/* 
				 * Valeur de type objet, si celui ci est de type "widget", on rcupre son nom
				 * avec la variable $z_widget_id, et on l'ajoute dans la ligne de commande.
				 * Si il ne l'est pas, on ne fait rien. (comment a je suis trop permissif ? ;)
				 */
				if (zend_hash_find(Z_OBJPROP_P((*z_args[i]) TSRMLS_CC), 
					"id", sizeof ("id"), (void **)&z_object_id) != FAILURE) 
				{
					tk_shell = erealloc (tk_shell, sizeof(char)*(strlen(tk_shell)
						+ (*z_object_id)->value.str.len+2));
					sprintf (tk_shell, "%s %s", tk_shell, (*z_object_id)->value.str.val); 
				}
			break;
			
			case IS_ARRAY:
				/* 
				 * Valeur de type tableau, on converti chaque valeur en string,
				 * et on les ajoute  la ligne de commande.
				 */
				convert_to_array_ex(z_args[i]);
				zend_hash_internal_pointer_reset_ex((*z_args[i])->value.ht, &z_hp);
		
				while (zend_hash_get_current_data_ex((*z_args[i])->value.ht, 
					(void **)&z_val, &z_hp) == SUCCESS) 
				{
					convert_to_string_ex (z_val);
					
					tk_shell = erealloc (tk_shell, sizeof(char)*(strlen(tk_shell) 
						+ (*z_val)->value.str.len+2));
					sprintf (tk_shell, "%s %s", tk_shell, (*z_val)->value.str.val);
					
					zend_hash_move_forward_ex ((*z_args[i])->value.ht, &z_hp); 
				}
			break;
			
			default:
				/* 
				 * switch par defaut, la valeur pet tre de type boolean, double, entier, ... 
				 * peu importe, on converti en chaine de caractre, et on ajoute.
				 */
				convert_to_string_ex (z_args[i]);
				
				tk_shell = erealloc (tk_shell, (strlen (tk_shell) 
					+ (*z_args[i])->value.str.len+2) * sizeof (char));
				sprintf (tk_shell, "%s %s", tk_shell, (*z_args[i])->value.str.val);
			break;
		}
	}

	/*
	 * On envoi la ligne de commande  la fonction php_tk_terminal
	 * qui s'occupe de l'envoyer  l'interpreteur TCL/TK.
	 * Celle ci retourne une chaine vide ou contenant une valeur, selon la macro TK_RETURN
	 */
	php_tk_terminal(return_value, tk_shell, TK_RETURN);
}
/* }}} */

/* {{{ php_tk_global_function
 */
static void php_tk_global_function(INTERNAL_FUNCTION_PARAMETERS, PARAM_TK_CMD, PARAM_TK_RETURN) {
	int z_argc = ZEND_NUM_ARGS();
	zval **z_args [z_argc], **z_object_id;
	
	char *tk_shell = emalloc(sizeof(char)*64);

	if (z_argc > 0) 
		if (zend_get_parameters_array_ex(z_argc, z_args) 
			== FAILURE) 
				WRONG_PARAM_COUNT;
	
	sprintf(tk_shell, "%s", TK_CMD);
	
	int i = 0;
	for (; i < z_argc; i++) {
		switch ((*z_args[i])->type) {
			/*
			 * cf php_tk_widget_command
			 */
			case IS_OBJECT:
				if (zend_hash_find(Z_OBJPROP_P((*z_args[i]) TSRMLS_CC), 
					"id", sizeof ("id"), (void **)&z_object_id) != FAILURE) 
				{
					tk_shell = erealloc (tk_shell, sizeof(char)*(strlen(tk_shell)
						+(*z_object_id)->value.str.len+2)); 
					sprintf (tk_shell, "%s %s", tk_shell, (*z_object_id)->value.str.val);
				}
			break;
			
			default:
				convert_to_string_ex (z_args[i]);
				
				tk_shell = erealloc(tk_shell, sizeof(char)*(strlen(tk_shell)
					+(*z_args[i])->value.str.len+2));
				sprintf (tk_shell, "%s %s", tk_shell, (*z_args[i])->value.str.val);
			break;
		}
	}

	php_tk_terminal(return_value, tk_shell, TK_RETURN);
}
/* }}} */

/* {{{ php_tk_terminal
 */
static void php_tk_terminal(zval *return_value, PARAM_TK_CMD, PARAM_TK_RETURN) {

	if (!php_tk->exit && !php_tk->loaded) {
			zend_error(E_ERROR, "Tk is not loaded");
	}

	/*
	 * Si l'option debug a t activ (Tk_Debug()) on affiche
	 * la ligne de commande
	 */
	if (php_tk->debug)
		zend_printf("Command: %s in %s on line %d\n", TK_CMD,
			zend_get_executed_filename(TSRMLS_C), zend_get_executed_lineno(TSRMLS_C));

	/*
	 * On envoi la commande  l'interpreteur TCL/TK.
	 * La technique utilis ici est celle-ci:
	 * On fait en sorte pour que l'intepreteur envoi la valeur de retour sur
	 * sa sortie standard, nous fesons prcder celle-ci par le caractre '~'.
	 * PS: cette valeur peut tre nulle.
	 */
	fprintf(php_tk->flux.p_out, "puts ~[%s]\n", TK_CMD);
	
	/*
	 * On rcupre la rponse sur le tube
	 */
	char *tk_return_value = emalloc(sizeof(char));
	php_get_line(&tk_return_value, php_tk->flux.p_in);
	
	switch (*(tk_return_value+0)) 
	{
	case '~':
		/*
		 * Si le premier caractre est gal  '~'
		 * et que la taille de la chaine est suprieur  1,
		 * on supprime le premier char, et on retourne cette chaine.
		 */
		if (strlen(tk_return_value) > 1) {
			php_strncpy(&tk_return_value, 1, strlen(tk_return_value));
			ZVAL_STRING(return_value, tk_return_value, 1);
		} 
			else 
		/*
		 * Ici, la chaine comporte un seul et unique caractre, le '~'
		 * On retourne un boolen positif, la commande n'a pas engendr d'erreur.
		 */
		{
			ZVAL_STRING(return_value, "", 1);
		}
	break;
	
	default:
		switch (TK_RETURN) {
			/*
			 * La commande est de type widget,
			 * On arrte l'execution en affichant une erreur fatale.
			 */
			case RETURN_WIDGET:
				zend_error(E_ERROR, tk_return_value); 
			break;
			
			/* Autre, on affiche un avertissement
			 * et on retourne une valeur de type boolen ngatif, la commande a chou.
			 */
			default:
				zend_error(E_WARNING, tk_return_value);
				
				return_value->type = IS_BOOL;
				return_value->value.lval = 0;
			break;
		}
	break;
	}
	
	efree(TK_CMD);
	efree(tk_return_value);
}
/* }}} */

/* {{{ php_tk_trace_event
 */
static void *php_tk_trace_event () {
	char *tk_message = (char*)emalloc(sizeof( char ));

	while (php_get_line(&tk_message, php_tk->flux.p_event)) 
	{	
		fprintf(php_tk->flux.p_out, "flush stderr\n");
		
		/*
		 * Nous devons recevoir uniquement des chaines dont le premier
		 * caractre est une arobase '@', c'est un callback
		 */
		 
		if (*(tk_message+0) != '@') {
			zend_error(E_WARNING, "invalid event \"%s\"", tk_message);
			continue;
		}
		
		/*
		 * La chaine rcupr ressemble  ceci:
		 * @function_name:param1:param2:...
		 * On enleve le premier caractre de la chaine.
		 */
		php_strncpy(&tk_message, 1, strlen (tk_message));
			
		/*
		 * Variables
		 */
		int next_token = 0, nb_token = 
			php_strchr(&tk_message, ':');
				
		zval *z_function, ***z_array = NULL, *z_retval = NULL;
			
		/*
		 * Puis on la split avec comme sparateur le caractre ':'
		 * On utilise le premier lement pour appeller la fonction utilisateur.
		 * Si d'autres lments il y'a, on gnre un tableau de paramtres.
		 */
		php_split *p_split = php_make_split(':', &tk_message);
		p_split = php_get_split(&tk_message, next_token++, p_split);
			
		MAKE_STD_ZVAL (z_function); 
		ZVAL_STRING (z_function, p_split->val_token, 1);
			
		if (nb_token < 1) 
		{
			if (call_user_function_ex(CG(function_table), NULL, z_function, 
				&z_retval, 0, NULL, 0, NULL TSRMLS_CC) != SUCCESS) 
			{
					zend_error(E_ERROR, "Call to undefined function: \"%s()\"\n", 
						z_function->value.str.val);
			}
		} 
		else 
		{
			z_array = (zval ***)safe_emalloc(nb_token, sizeof(zval **), 0);
				
			int key; 
			for (key = 0; key < nb_token; key++)
			{
				p_split = php_get_split(&tk_message, next_token++, p_split);
					
				z_array[key] = emalloc(sizeof(zval *));
					
				MAKE_STD_ZVAL(*z_array[key]);
				ZVAL_STRING(*z_array[key], p_split->val_token, 1);			
			}
				
			if (call_user_function_ex(CG(function_table), NULL, z_function, 
				&z_retval, nb_token, z_array, 0, NULL TSRMLS_CC) != SUCCESS) 
			{
					zend_error(E_ERROR, "Call to undefined function \"%s()\"\n", 
						z_function->value.str.val);
			}
				
			if (z_array) {
				for (key = 0; key < nb_token; key++) {
					zval_ptr_dtor(z_array[key]);
					efree(z_array[key]);
				}
				efree(z_array);
			}
		}
			
		if (z_retval) {
			zval_ptr_dtor(&z_retval);
		}
			
		zval_ptr_dtor(&z_function);
		FREE_STRUCT(p_split);
	}
	pthread_exit(NULL);
}
/* }}} */

/* {{{ php_tk_addslashes
 */
static int php_tk_addslashes(zval *return_value, char *p_string) {
	
	int i, j, count = 0;
	
	for (i = 0; *(p_string+i) != '\0'; i++)
	{
		switch (*(p_string+i)) 
		{
			case '[':
			case ']':
			case '$':
			case '{':
			case '}':
			case '"':
			case '\'':
				count++;
			break;
		}
	}
	
	if (count < 1) {
		ZVAL_STRING(return_value, p_string, 1);
		return 0;
	}

	char *p_buffer = emalloc( 
		sizeof(char)*(3+strlen(p_string)+count)
	);
//
	*(p_buffer+0) = '"';
//
	for (i = 0, j = 1; *(p_string+i) != '\0'; i++, j++)
	{
		switch (*(p_string+i))
		{
			case '[':
			case ']':
			case '$':
			case '{':
			case '}':
			case '"':
			case '\'':
				*(p_buffer+j) = '\\';
				j++;
				*(p_buffer+j) = *(p_string+i);
			break;
			
			default:
				*(p_buffer+j) = *(p_string+i);
			break;
		}
	}
//	
	*(p_buffer+(j)) = '"';
//
	*(p_buffer+(j+1)) = '\0';
	
	ZVAL_STRING(return_value, p_buffer, 1);
	
	return 1;
}
/* }}} */

/* {{{ tcl_list_to_array
	Example:
	tcl_listToArray("{un deux {trois quatre} cinque}")
		return
	Array
	(
		[0] => un
		[1] => deux
		[2] => Array
		  (
			  [0] => trois
			  [1] => quatre
		  )
		[3] => cinque
	)
 */
static void php_tcl_list_to_array (zval **new_array, char *tcl_list) {
	int bEnd = 0, key = 0;
	int str_len = strlen(tcl_list);

	array_init(*new_array);
	
	int iTokenLen = 0, iCountChar = 0;
	for (; iCountChar < str_len; ++iCountChar, ++iTokenLen) {
		switch (*(tcl_list+iCountChar)) {
			case '}':
				if (iCountChar == str_len-1){
					bEnd = 1; }
				break;
		}
		/* -> */
		if (*(tcl_list+iCountChar) == '{') {
			if (iCountChar != 0) {
				int iLoopBoolean = 1;
				int iAccodsOpen = 0;
				int iListLen = 1;
				while (iLoopBoolean) {
					switch (*(tcl_list+(iCountChar+iListLen))) {
						case '{': iAccodsOpen++; break;
						case '}':
							if (iAccodsOpen != 0) {
								iAccodsOpen--; }
							else {
								iLoopBoolean = 0; }
						break;
					}
					iListLen++;
				}
				/*
				 * ->
				 */
				char new_tcl_list[iListLen-1];
				
				int iCountLen = 0;
				int iCharIndex = iCountChar;
				for (; iCountLen < iListLen; ++iCountLen) {
					new_tcl_list[iCountLen]= *(tcl_list+(iCountLen+iCountChar));
				}
				new_tcl_list[iCountLen] = '\0';
				iCountChar += iListLen+1;
				iTokenLen = 1;
				/*
				 * ->
				 */
				zval *imbricated_array;
				MAKE_STD_ZVAL(imbricated_array);
				php_tcl_list_to_array(&imbricated_array, new_tcl_list);
				zend_hash_index_update((*new_array)->value.ht, key++, (void *)&imbricated_array, 
					sizeof(zval *), NULL);
			}
		}
		else if (bEnd || *(tcl_list+iCountChar) == ' ')	{
			if (iTokenLen < 2) {
				continue; 
			}
			char tChar[iTokenLen-1];
			int iIncr, iStrChar = (iCountChar-iTokenLen)+1;
			for (iIncr=0; iStrChar < iCountChar; iIncr++, iStrChar++) {
				if (*(tcl_list+iStrChar) != '}') {
					tChar[iIncr] = *(tcl_list+iStrChar); }
			}
			tChar[iTokenLen-1]='\0';
			iTokenLen = 0;
			/*
			* ->
			*/
			zval *new_string;
			MAKE_STD_ZVAL(new_string);

			new_string->type = IS_STRING;
			new_string->value.str.len = strlen(tChar);
			new_string->value.str.val = estrdup(tChar);
				
			zend_hash_index_update((*new_array)->value.ht, key++, (void *)&new_string, 
				sizeof(zval *), NULL);
			bEnd=0;
		}
	}
}
/* }}} */

/* {{{ php_get_line
 *	function recovering a whole line on the pointer of indicated file
 */
static int php_get_line (char **r_string, FILE *flux) {	
	
	int boolean = 0;
	char *t_string = NULL, b_string[64];

	efree (*r_string);
	*r_string = emalloc (sizeof (char));

	while (fgets(b_string, sizeof (b_string), flux) != NULL) 
	{
		char *n_chr = strchr(b_string, '\n');
		
		if (n_chr) {
			*n_chr = '\0'; 
			boolean = 1;
		}
		
		if (t_string != NULL) {
			t_string = erealloc(t_string, sizeof(char)*
				(1+strlen(t_string)+strlen(b_string)));
				
			if (t_string == NULL) 
				zend_error(E_ERROR, "insufficient memory");
			
			strcat (t_string, b_string);
		} 
		else {
			t_string = emalloc(sizeof(char)*(strlen(b_string)+1)); 
			if (t_string == NULL)
				zend_error(E_ERROR, "insufficient memory");
			
			strcpy (t_string, b_string);
		}
		
		if (boolean == 1) {
			boolean = 0;
			*r_string = erealloc(*r_string, sizeof(char)*(strlen(t_string)+1));
			
			if (*r_string == NULL)
				zend_error(E_ERROR, "insufficient memory");
			
			strcpy (*r_string, t_string); 
			efree (t_string); 
			
			return 1;
		}
	}
	
	if (t_string != NULL)
		efree (t_string);
	
	efree (*r_string);     
	
	return 0;
/*}*/
}
/* }}} */

/* {{{ php_popen
 */
static int php_popen (char *exec_path) {
	
	int pid;
	int t_pf [2]; // tube pre au fils
	int t_fp [2]; // tube fils au pre
	int t_gv [2]; // tube pre au fils pour rcuprer variables

	if (-1 == pipe (t_pf) 
		|| -1 == pipe (t_fp)
			|| -1 == pipe (t_gv)) {
		return 0;
	}

	if ((pid = fork ()) == 0) { // processus fils
		close (0); dup (t_pf [0]); // redirige stdin vers le tube ou le pre crit
		close (1); dup (t_fp [1]); // redirige stdout vers le tube ou le fils crit
		close (2); dup (t_gv [1]);
		
		close (t_pf [0]); 
		close (t_pf [1]);
		
		close (t_fp [0]); 
		close (t_fp [1]); 
		
		close (t_gv [0]);
		close (t_gv [1]);

		execlp (exec_path, exec_path, NULL);
	}
	
	else if (pid > 0) { // processus parent
		if (!(php_tk->flux.p_in = fdopen (t_fp [0], "r"))) { return 0; }
		if (!(php_tk->flux.p_out = fdopen (t_pf [1], "w"))) { return 0; }
		if (!(php_tk->flux.p_event = fdopen (t_gv [0], "r"))) { return 0; }
		
		setbuf(php_tk->flux.p_out, NULL);
		
		close(t_pf [0]); 
		close(t_fp [1]);
		close(t_gv[1]);

		fprintf(php_tk->flux.p_out, "wm title . \"PHP/TK\"\n");
	}
	
	else { 
		exit(1); 
	}
	
	return 1;
}
/* }}} */

/* {{{ php_make_split
 */
static php_split *php_make_split (char pattern, char **r_string) {
	int len = php_strchr (*(&r_string), pattern) + 1;
	
	php_split *p_split = (php_split *) emalloc (sizeof (php_split));
	
	p_split->val_token = emalloc (sizeof(char));
	p_split->ref_tokens = emalloc (sizeof(char) * (len * 2));
	
	int i_split = 0, n_split, c_split;
	
	for (n_split = 0, c_split = 0; ; i_split++) {
		if (*(*r_string + i_split) == pattern ||
			*(*r_string + i_split) == '\0') {
				*(p_split->ref_tokens + c_split++) = (char)n_split;
				*(p_split->ref_tokens + c_split++) = (char)i_split - 1; 
				
				n_split = i_split + 1; }
		
		if (i_split == strlen (*r_string)) {
			break; }
	}
	
	p_split->count_tokens = len;
	
	return (p_split);
}
/* }}} */

/* {{{ php_get_split
 */
static php_split *php_get_split (char **r_string, int p_index, php_split *p_split) {
	/**/
	int srt = (int)*(p_split->ref_tokens + ((p_index * 2) + 0));
	int len = (int)*(p_split->ref_tokens + ((p_index * 2) + 1));

	p_split->val_token = erealloc (p_split->val_token, sizeof (char) * ((len - srt) + 2));

	int i; for (i = 0; srt <= len; srt++, i++) {
		*(p_split->val_token + i) = *(*r_string + srt); }
	*(p_split->val_token + i) = '\0';
	
	return (p_split);
}
/* }}} */

/* {{{ php_strncpy
 */
static void php_strncpy (char **p_string, int start, int len) {
	int l = (len - start ) + 1;
	char tmp_b [l];
	
	int i, j;
	for (i = 0, j = start; i < l; i++, j++) {
		tmp_b [ i ] = *(*p_string + j);
	}
	efree (*p_string);
	*p_string = estrdup (tmp_b);
}
/* }}} */

/* {{{ php_strncmp
 */
static int  php_strncmp (char **b_string, char *c_string, int offset) {
	int i; for (i = 0; i <= offset; i++, c_string++) {
		if ('\0' != *c_string || '\0' != *(*b_string + i)) {
			if (*c_string != *(*b_string + i)) {
				return 1;
			}
		}
		else return 1;
	}
	return 0;
}
/* }}} */

/* {{{ php_strchr
 */
static int php_strchr (char **p_string, char pattern) {
	int i, c = 0;
	for (i = 0; *(*p_string + i) != '\0'; ++i) {
		c = (*(*p_string + i) != pattern) ? c:++c;
	}
	return c;
}
/* }}} */

/* END C STANDART CODE */



/* {{{ PHP_MINIT_FUNCTION
 */
PHP_MINIT_FUNCTION(php_tk)
{		
	php_tk->loaded = 0;
	php_tk->debug = 0;
	php_tk->exit = 0;
	php_tk->widget_assign = 0;
	
	zend_class_entry php_tk_ce;
	zend_class_entry php_tk_bitmap_ce;
	zend_class_entry php_tk_button_ce;
	zend_class_entry php_tk_canvas_ce;
	zend_class_entry php_tk_checkbutton_ce;
	zend_class_entry php_tk_entry_ce;
	zend_class_entry php_tk_font_ce;
	zend_class_entry php_tk_frame_ce;
	zend_class_entry php_tk_label_ce;
	zend_class_entry php_tk_labelframe_ce;
	zend_class_entry php_tk_listbox_ce;
	zend_class_entry php_tk_menu_ce;
	zend_class_entry php_tk_menubutton_ce;
	zend_class_entry php_tk_message_ce;
	zend_class_entry php_tk_panedwindow_ce;
	zend_class_entry php_tk_photo_ce;
	zend_class_entry php_tk_radiobutton_ce;
	zend_class_entry php_tk_scale_ce;
	zend_class_entry php_tk_scrollbar_ce;
	zend_class_entry php_tk_spinbox_ce;
	zend_class_entry php_tk_text_ce;
	zend_class_entry php_tk_textcopy_ce;
	zend_class_entry php_tk_textcut_ce;
	zend_class_entry php_tk_textpaste_ce;
	zend_class_entry php_tk_toplevel_ce;
	
	/* {{{ ???
	
	le_tk = zend_register_list_destructors_ex(php_destroy_tk_object_resource, NULL, "tk", module_number);
	le_tk_bitmap = zend_register_list_destructors_ex(php_destroy_tk_object_resource, NULL, "bitmap", module_number);
	le_tk_button = zend_register_list_destructors_ex(php_destroy_tk_object_resource, NULL, "button", module_number);
	le_tk_canvas = zend_register_list_destructors_ex(php_destroy_tk_object_resource, NULL, "canvas", module_number);
	le_tk_checkbutton = zend_register_list_destructors_ex(php_destroy_tk_object_resource, NULL, "checkbutton", module_number);
	le_tk_entry = zend_register_list_destructors_ex(php_destroy_tk_object_resource, NULL, "entry", module_number);
	le_tk_font = zend_register_list_destructors_ex(php_destroy_tk_object_resource, NULL, "font", module_number);
	le_tk_frame = zend_register_list_destructors_ex(php_destroy_tk_object_resource, NULL, "frame", module_number);
	le_tk_label = zend_register_list_destructors_ex(php_destroy_tk_object_resource, NULL, "label", module_number);
	le_tk_labelframe = zend_register_list_destructors_ex(php_destroy_tk_object_resource, NULL, "labelframe", module_number);
	le_tk_listbox = zend_register_list_destructors_ex(php_destroy_tk_object_resource, NULL, "listbox", module_number);
	le_tk_menu = zend_register_list_destructors_ex(php_destroy_tk_object_resource, NULL, "menu", module_number);
	le_tk_menubutton = zend_register_list_destructors_ex(php_destroy_tk_object_resource, NULL, "menubutton", module_number);
	le_tk_message = zend_register_list_destructors_ex(php_destroy_tk_object_resource, NULL, "message", module_number);
	le_tk_panedwindow = zend_register_list_destructors_ex(php_destroy_tk_object_resource, NULL, "panedwindow", module_number);
	le_tk_photo = zend_register_list_destructors_ex(php_destroy_tk_object_resource, NULL, "photo", module_number);
	le_tk_radiobutton = zend_register_list_destructors_ex(php_destroy_tk_object_resource, NULL, "radiobutton", module_number);
	le_tk_scale = zend_register_list_destructors_ex(php_destroy_tk_object_resource, NULL, "scale", module_number);
	le_tk_scrollbar = zend_register_list_destructors_ex(php_destroy_tk_object_resource, NULL, "scrollbar", module_number);
	le_tk_spinbox = zend_register_list_destructors_ex(php_destroy_tk_object_resource, NULL, "spinbox", module_number);
	le_tk_text = zend_register_list_destructors_ex(php_destroy_tk_object_resource, NULL, "text", module_number);
	le_tk_textcopy = zend_register_list_destructors_ex(php_destroy_tk_object_resource, NULL, "textcopy", module_number);
	le_tk_textcut = zend_register_list_destructors_ex(php_destroy_tk_object_resource, NULL, "textcut", module_number);
	le_tk_textpaste = zend_register_list_destructors_ex(php_destroy_tk_object_resource, NULL, "textpaste", module_number);
	le_tk_toplevel = zend_register_list_destructors_ex(php_destroy_tk_object_resource, NULL, "toplevel", module_number);
	
	* }}} */
	
	
	INIT_CLASS_ENTRY(php_tk_ce, "tk", oO_functions);
	
	/* {{{ generate init class code */
	INIT_CLASS_ENTRY(php_tk_bitmap_ce, "bitmap", bitmap_functions);
	INIT_CLASS_ENTRY(php_tk_button_ce, "button", oO_functions);
	INIT_CLASS_ENTRY(php_tk_canvas_ce, "canvas", oO_functions);
	INIT_CLASS_ENTRY(php_tk_checkbutton_ce, "checkbutton", oO_functions);
	INIT_CLASS_ENTRY(php_tk_entry_ce, "entry", oO_functions);
	INIT_CLASS_ENTRY(php_tk_font_ce, "font", font_functions);
	INIT_CLASS_ENTRY(php_tk_frame_ce, "frame", oO_functions);
	INIT_CLASS_ENTRY(php_tk_label_ce, "label", oO_functions);
	INIT_CLASS_ENTRY(php_tk_labelframe_ce, "labelframe", oO_functions);
	INIT_CLASS_ENTRY(php_tk_listbox_ce, "listbox", oO_functions);
	INIT_CLASS_ENTRY(php_tk_menu_ce, "menu", oO_functions);
	INIT_CLASS_ENTRY(php_tk_menubutton_ce, "menubutton", oO_functions);
	INIT_CLASS_ENTRY(php_tk_message_ce, "message", oO_functions);
	INIT_CLASS_ENTRY(php_tk_panedwindow_ce, "panedwindow", oO_functions);
	INIT_CLASS_ENTRY(php_tk_photo_ce, "photo", photo_functions);
	INIT_CLASS_ENTRY(php_tk_radiobutton_ce, "radiobutton", oO_functions);
	INIT_CLASS_ENTRY(php_tk_scale_ce, "scale", scale_functions);
	INIT_CLASS_ENTRY(php_tk_scrollbar_ce, "scrollbar", oO_functions);
	INIT_CLASS_ENTRY(php_tk_spinbox_ce, "spinbox", oO_functions);
	INIT_CLASS_ENTRY(php_tk_text_ce, "text", oO_functions);
	INIT_CLASS_ENTRY(php_tk_textcopy_ce, "textcopy", oO_functions);
	INIT_CLASS_ENTRY(php_tk_textcut_ce, "textcut", oO_functions);
	INIT_CLASS_ENTRY(php_tk_textpaste_ce, "textpaste", oO_functions);
	INIT_CLASS_ENTRY(php_tk_toplevel_ce, "toplevel", oO_functions);
	/* }}} */
	
	php_tk_ce_ptr = zend_register_internal_class(&php_tk_ce TSRMLS_CC);
	/* {{{ generate register class code */
	php_tk_bitmap_ce_ptr = zend_register_internal_class(&php_tk_bitmap_ce TSRMLS_CC);
	php_tk_button_ce_ptr = zend_register_internal_class(&php_tk_button_ce TSRMLS_CC);
	php_tk_canvas_ce_ptr = zend_register_internal_class(&php_tk_canvas_ce TSRMLS_CC);
	php_tk_checkbutton_ce_ptr = zend_register_internal_class(&php_tk_checkbutton_ce TSRMLS_CC);
	php_tk_entry_ce_ptr = zend_register_internal_class(&php_tk_entry_ce TSRMLS_CC);
	php_tk_font_ce_ptr = zend_register_internal_class(&php_tk_font_ce TSRMLS_CC);
	php_tk_frame_ce_ptr = zend_register_internal_class(&php_tk_frame_ce TSRMLS_CC);
	php_tk_label_ce_ptr = zend_register_internal_class(&php_tk_label_ce TSRMLS_CC);
	php_tk_labelframe_ce_ptr = zend_register_internal_class(&php_tk_labelframe_ce TSRMLS_CC);
	php_tk_listbox_ce_ptr = zend_register_internal_class(&php_tk_listbox_ce TSRMLS_CC);
	php_tk_menu_ce_ptr = zend_register_internal_class(&php_tk_menu_ce TSRMLS_CC);
	php_tk_menubutton_ce_ptr = zend_register_internal_class(&php_tk_menubutton_ce TSRMLS_CC);
	php_tk_message_ce_ptr = zend_register_internal_class(&php_tk_message_ce TSRMLS_CC);
	php_tk_panedwindow_ce_ptr = zend_register_internal_class(&php_tk_panedwindow_ce TSRMLS_CC);
	php_tk_photo_ce_ptr = zend_register_internal_class(&php_tk_photo_ce TSRMLS_CC);
	php_tk_radiobutton_ce_ptr = zend_register_internal_class(&php_tk_radiobutton_ce TSRMLS_CC);
	php_tk_scale_ce_ptr = zend_register_internal_class(&php_tk_scale_ce TSRMLS_CC);
	php_tk_scrollbar_ce_ptr = zend_register_internal_class(&php_tk_scrollbar_ce TSRMLS_CC);
	php_tk_spinbox_ce_ptr = zend_register_internal_class(&php_tk_spinbox_ce TSRMLS_CC);
	php_tk_text_ce_ptr = zend_register_internal_class(&php_tk_text_ce TSRMLS_CC);
	php_tk_textcopy_ce_ptr = zend_register_internal_class(&php_tk_textcopy_ce TSRMLS_CC);
	php_tk_textcut_ce_ptr = zend_register_internal_class(&php_tk_textcut_ce TSRMLS_CC);
	php_tk_textpaste_ce_ptr = zend_register_internal_class(&php_tk_textpaste_ce TSRMLS_CC);
	php_tk_toplevel_ce_ptr = zend_register_internal_class(&php_tk_toplevel_ce TSRMLS_CC);
	/* }}} */
	
	return SUCCESS;
}
/* }}} */

/* {{{ PHP_MINFO_FUNCTION
 */
PHP_MINFO_FUNCTION(php_tk)
{
	php_info_print_table_start();
	php_info_print_table_header(2, "Tk support", "enabled");
	php_info_print_table_end();
}
/* }}} */

/* {{{ PHP_MSHUTDOWN_FUNCTION
 */
PHP_MSHUTDOWN_FUNCTION(php_tk)
{
	pthread_kill(php_tk->thread, SIGINT);

	if (php_tk->loaded)
		if (!php_tk->debug)
			fprintf(php_tk->flux.p_out, "exit\n");
	
	fclose(php_tk->flux.p_out);
	fclose(php_tk->flux.p_in);
	fclose(php_tk->flux.p_event);
	
	return SUCCESS;
}
/* }}} */

/* {{{ PHP_RSHUTDOWN_FUNCTION
 */ 
PHP_RSHUTDOWN_FUNCTION(php_tk)
{
	fprintf(php_tk->flux.p_out, "exit\n");
	php_tk->loaded = 0;
		
	return SUCCESS;
}
/* }}} */

/* {{{ proto object new Tk([string path_to_elf])
 */
PHP_FUNCTION (za_tk) 
{
	int argc;
	int elf_len;
	char *elf_path;
	char *elf_name;
	char *user_path;
	
	FILE *is_file;

	if (1 == (argc = ZEND_NUM_ARGS())) {
		if (zend_parse_parameters(ZEND_NUM_ARGS () TSRMLS_CC, "s", 
			&elf_name, &elf_len) == FAILURE) 
		{
			WRONG_PARAM_COUNT;
		}
		if (!(is_file = fopen(elf_name, "r"))) {
				RETURN_FALSE; 
		}
	}
	
	char *str_getenv;
		
	if (!(str_getenv = getenv("PATH"))) {
		user_path = estrdup("/bin:/usr/bin/:/usr/local/bin/");
	} else {
		if (str_getenv[strlen(str_getenv)] != ':') {
			user_path = emalloc(strlen (str_getenv) + 1);
			strcpy (user_path, str_getenv);
		} else {
			user_path = emalloc(strlen (str_getenv));
			strncpy(user_path, str_getenv, strlen (str_getenv)-1);
		}
	}
	
	php_split *p_split = php_make_split(':', &user_path);
	
	int i; for (i = 0; i < p_split->count_tokens; ++i) {
		/**/
		p_split = php_get_split(&user_path, i, p_split);
		int path_len = strlen(p_split->val_token);
		
		if (p_split->val_token[path_len] != '/') {
			elf_path = emalloc(sizeof(char)*(path_len+6));
			sprintf (elf_path, "%s/wish", p_split->val_token);
		} else {
			elf_path = emalloc(sizeof(char)*(path_len+5));
			sprintf(elf_path, "%swish", p_split->val_token);
		}

		if (is_file = fopen(elf_path, "r")) {
			break;
		}
		
		efree(elf_path); elf_path = NULL;
	}

	efree(user_path);
	
	FREE_STRUCT(p_split);
	
	if (is_file) {
		fclose(is_file); }

	if (NULL == elf_path 
		|| !php_popen(elf_path)) {
			RETURN_FALSE; }
	else { 
		efree(elf_path); 
		
		object_init_ex(getThis(), php_tk_ce_ptr);
		add_property_string(getThis(), "id", ".", 1);
		
		php_tk->loaded = 1;
		RETURN_TRUE; }
}
/* }}} */

/* {{{ proto Tk_mainLoop(...)
 *	boucle evenementiel
 */
PHP_FUNCTION(za_tk_mainloop)
{
	if (!php_tk->loaded)
		zend_error(E_ERROR, "Tk is not loaded");

	if (0 != pthread_create (&php_tk->thread, NULL, php_tk_trace_event, NULL)) {
		zend_error(E_ERROR, "cannot create thread");
	}
	pthread_join (php_tk->thread, NULL);
}
/* }}} */

/* {{{ proto Tk_exit()
 *
 */
PHP_FUNCTION(za_tk_exit)
{
	fprintf(php_tk->flux.p_out, "exit\n");
	
	php_tk->loaded = 0;
	php_tk->exit = 1;
}
/* }}} */

/* {{{ proto string Tk_Callback(string function_name, [mixed param[...]])
 */
PHP_FUNCTION(za_tk_callback)
{
	char *callback_name;
	
	int arg_c =
		ZEND_NUM_ARGS();
	
	zval **arg_v[arg_c];
	
	if (1 > arg_c || zend_get_parameters_array_ex(arg_c, arg_v) 
		== FAILURE)
			WRONG_PARAM_COUNT;

	convert_to_string_ex(arg_v[0]);
	callback_name = estrdup((*arg_v[0])->value.str.val);
	
	if (!zend_is_callable(*arg_v[0], 0, &callback_name)) {
		zend_error(E_ERROR, "%s() requires argument 1, '%s', to be a valid callback",
				get_active_function_name(), callback_name);
	}
	efree(callback_name);
	
	int i;
	char *tcl_line = estrdup("{puts stderr ");
	
	for(i = 0; i < arg_c; i++) {
		char c_preffix = (i != 0) ? ':':'@';
		convert_to_string_ex(arg_v[i]);
		
		tcl_line = erealloc(tcl_line, sizeof(char)
				*(strlen(tcl_line)+(*arg_v[i])->value.str.len+2));
		
		sprintf(tcl_line, "%s%c%s", tcl_line, c_preffix, (*arg_v[i])->value.str.val);
	}
	tcl_line = erealloc(tcl_line, strlen(tcl_line)+2);
	sprintf(tcl_line, "%s}", tcl_line);
	
	ZVAL_STRING(return_value, tcl_line, 1);
	efree(tcl_line);
}
/* }}} */

/* {{{ proto Tk_Debug()
 */
PHP_FUNCTION(za_tk_debug)
{
	if (ZEND_NUM_ARGS() != 0)
		WRONG_PARAM_COUNT;
		
	php_tk->debug = 1;
}
/* }}} */

/* {{{ proto string Obj->getID()
 * 	return name of widget class
 */
PHP_FUNCTION(za_getid)
{
	zval *z_object_id;
	zval **z_object_tmp;
	
	if (zend_hash_find(Z_OBJPROP_P(getThis() TSRMLS_CC), "id", sizeof("id"), 
		(void **)&z_object_tmp) != FAILURE) {
			RETURN_STRINGL((*z_object_tmp)->value.str.val, (*z_object_tmp)->value.str.len, 1);
	} else {
		RETURN_FALSE; }
}
/* }}} */


/* {{{ proto mixed Tk_Shell([...])
 */
PHP_FUNCTION(za_tk_shell)
{
	php_tk_global_function(INTERNAL_FUNCTION_PARAM_PASSTHRU, "", RETURN_TCL);
}
/* }}} */


/* {{{ proto string Tk_Addslashes(string buffer)
 */
PHP_FUNCTION(za_tk_addslashes)
{
	int str_len;
	char *str_val;
	
	if (zend_parse_parameters(ZEND_NUM_ARGS() 
		TSRMLS_CC, "s", &str_val, &str_len) == FAILURE)
	{
			WRONG_PARAM_COUNT;
	}
	
	php_tk_addslashes(return_value, str_val);
}
/* }}} */


/* {{{ proto array Tcl_ListToArray(string tcl_list)
 */
PHP_FUNCTION(za_tcl_listtoarray)
{
	int str_len;
	char *str_val;
	
	if (zend_parse_parameters (ZEND_NUM_ARGS() TSRMLS_CC, "s", &str_val, &str_len) == FAILURE) {
		WRONG_PARAM_COUNT;
	}
	
	/*
	 * si la chaine n'est pas dlimit par '{' et '{', on les ajoute
	 * pour son utilisation avec php_tcl_list_to_array.
	 */
	if (*(str_val+0) != '{') {
		char str_tmp[str_len+3];
		sprintf(str_tmp, "{%s}", str_val);
		php_tcl_list_to_array(&return_value, str_tmp);
	} else {
		php_tcl_list_to_array(&return_value, str_val);
	}
}

/* {{{ GENERATE Tk Global functions
 */

/* {{{ proto Tk_AppName([String new_name])
 */
PHP_FUNCTION(za_tk_appname) {
	php_tk_global_function(INTERNAL_FUNCTION_PARAM_PASSTHRU, "tk appname", RETURN_EMPTY); }
/* }}} */

/* {{{ proto mixed Tk_Bisque(...)
 */
PHP_FUNCTION(za_tk_bisque) {
	php_tk_global_function(INTERNAL_FUNCTION_PARAM_PASSTHRU, "tk_bisque", RETURN_TCL); }
/* }}} */

/* {{{ proto mixed Tk_ChooseColor(...)
 */
PHP_FUNCTION(za_tk_choosecolor) {
	php_tk_global_function(INTERNAL_FUNCTION_PARAM_PASSTHRU, "tk_choosecolor", RETURN_TCL); }
/* }}} */

/* {{{ proto mixed Tk_ChooseDirectory(...)
 */
PHP_FUNCTION(za_tk_choosedirectory) {
	php_tk_global_function(INTERNAL_FUNCTION_PARAM_PASSTHRU, "tk_choosedirectory", RETURN_TCL); }
/* }}} */

/* {{{ proto mixed Tk_Dialog(...)
 */
PHP_FUNCTION(za_tk_dialog) {
	php_tk_global_function(INTERNAL_FUNCTION_PARAM_PASSTHRU, "tk_dialog", RETURN_TCL); }
/* }}} */

/* {{{ proto  Tk_EventAdd(...)
 */
PHP_FUNCTION(za_tk_eventadd) {
	php_tk_global_function(INTERNAL_FUNCTION_PARAM_PASSTHRU, "event add", RETURN_EMPTY); }
/* }}} */

/* {{{ proto  Tk_EventDelete(...)
 */
PHP_FUNCTION(za_tk_eventdelete) {
	php_tk_global_function(INTERNAL_FUNCTION_PARAM_PASSTHRU, "event delete", RETURN_EMPTY); }
/* }}} */

/* {{{ proto  Tk_EventGenerate(...)
 */
PHP_FUNCTION(za_tk_eventgenerate) {
	php_tk_global_function(INTERNAL_FUNCTION_PARAM_PASSTHRU, "event generate", RETURN_EMPTY); }
/* }}} */

/* {{{ proto mixed Tk_EventInfo(...)
 */
PHP_FUNCTION(za_tk_eventinfo) {
	php_tk_global_function(INTERNAL_FUNCTION_PARAM_PASSTHRU, "event", RETURN_TCL); }
/* }}} */

/* {{{ proto mixed Tk_FocusFollowsMouse(...)
 */
PHP_FUNCTION(za_tk_focusfollowsmouse) {
	php_tk_global_function(INTERNAL_FUNCTION_PARAM_PASSTHRU, "tk_focusfollowsmouse", RETURN_TCL); }
/* }}} */

/* {{{ proto mixed Tk_FocusNext(...)
 */
PHP_FUNCTION(za_tk_focusnext) {
	php_tk_global_function(INTERNAL_FUNCTION_PARAM_PASSTHRU, "tk_focusnext", RETURN_TCL); }
/* }}} */

/* {{{ proto mixed Tk_FocusPrev(...)
 */
PHP_FUNCTION(za_tk_focusprev) {
	php_tk_global_function(INTERNAL_FUNCTION_PARAM_PASSTHRU, "tk_focusprev", RETURN_TCL); }
/* }}} */

/* {{{ proto mixed Tk_FontFamilies(...)
 */
PHP_FUNCTION(za_tk_fontfamilies) {
	php_tk_global_function(INTERNAL_FUNCTION_PARAM_PASSTHRU, "font families", RETURN_TCL); }
/* }}} */

/* {{{ proto mixed Tk_FontNames(...)
 */
PHP_FUNCTION(za_tk_fontnames) {
	php_tk_global_function(INTERNAL_FUNCTION_PARAM_PASSTHRU, "font names", RETURN_TCL); }
/* }}} */

/* {{{ proto mixed Tk_GetOpenFile(...)
 */
PHP_FUNCTION(za_tk_getopenfile) {
	php_tk_global_function(INTERNAL_FUNCTION_PARAM_PASSTHRU, "tk_getopenfile", RETURN_TCL); }
/* }}} */

/* {{{ proto mixed Tk_GetSaveFile(...)
 */
PHP_FUNCTION(za_tk_getsavefile) {
	php_tk_global_function(INTERNAL_FUNCTION_PARAM_PASSTHRU, "tk_getsavefile", RETURN_TCL); }
/* }}} */

/* {{{ proto mixed Tk_ImageNames(...)
 */
PHP_FUNCTION(za_tk_imagenames) {
	php_tk_global_function(INTERNAL_FUNCTION_PARAM_PASSTHRU, "image names", RETURN_TCL); }
/* }}} */

/* {{{ proto mixed Tk_ImageTypes(...)
 */
PHP_FUNCTION(za_tk_imagetypes) {
	php_tk_global_function(INTERNAL_FUNCTION_PARAM_PASSTHRU, "image types", RETURN_TCL); }
/* }}} */

/* {{{ proto mixed Tk_MessageBox(...)
 */
PHP_FUNCTION(za_tk_messagebox) {
	php_tk_global_function(INTERNAL_FUNCTION_PARAM_PASSTHRU, "tk_messageBox", RETURN_TCL); }
/* }}} */

/* {{{ proto  Tk_OptionAdd(...)
 */
PHP_FUNCTION(za_tk_optionadd) {
	php_tk_global_function(INTERNAL_FUNCTION_PARAM_PASSTHRU, "option add", RETURN_EMPTY); }
/* }}} */

/* {{{ proto  Tk_OptionClear(...)
 */
PHP_FUNCTION(za_tk_optionclear) {
	php_tk_global_function(INTERNAL_FUNCTION_PARAM_PASSTHRU, "option clear", RETURN_EMPTY); }
/* }}} */

/* {{{ proto mixed Tk_OptionGet(...)
 */
PHP_FUNCTION(za_tk_optionget) {
	php_tk_global_function(INTERNAL_FUNCTION_PARAM_PASSTHRU, "option get", RETURN_TCL); }
/* }}} */

/* {{{ proto mixed Tk_OptionMenu(...)
 */
PHP_FUNCTION(za_tk_optionmenu) {
	php_tk_global_function(INTERNAL_FUNCTION_PARAM_PASSTHRU, "tk_optionmenu", RETURN_TCL); }
/* }}} */

/* {{{ proto mixed Tk_OptionReadFile(...)
 */
PHP_FUNCTION(za_tk_optionreadfile) {
	php_tk_global_function(INTERNAL_FUNCTION_PARAM_PASSTHRU, "option readfile", RETURN_TCL); }
/* }}} */

/* {{{ proto mixed Tk_Popup(...)
 */
PHP_FUNCTION(za_tk_popup) {
	php_tk_global_function(INTERNAL_FUNCTION_PARAM_PASSTHRU, "tk_popup", RETURN_TCL); }
/* }}} */

/* {{{ proto  Tk_Scaling(...)
 */
PHP_FUNCTION(za_tk_scaling) {
	php_tk_global_function(INTERNAL_FUNCTION_PARAM_PASSTHRU, "tk scaling", RETURN_TCL); }
/* }}} */

/* {{{ proto  Tk_SelectionClear(...)
 */
PHP_FUNCTION(za_tk_selectionclear) {
	php_tk_global_function(INTERNAL_FUNCTION_PARAM_PASSTHRU, "selection clear", RETURN_EMPTY); }
/* }}} */

/* {{{ proto mixed Tk_SelectionGet(...)
 */
PHP_FUNCTION(za_tk_selectionget) {
	php_tk_global_function(INTERNAL_FUNCTION_PARAM_PASSTHRU, "selection get", RETURN_TCL); }
/* }}} */

/* {{{ proto mixed Tk_SelectionHandle(...)
 */
PHP_FUNCTION(za_tk_selectionhandle) {
	php_tk_global_function(INTERNAL_FUNCTION_PARAM_PASSTHRU, "selection handle", RETURN_TCL); }
/* }}} */

/* {{{ proto mixed Tk_SelectionOwn(...)
 */
PHP_FUNCTION(za_tk_selectionown) {
	php_tk_global_function(INTERNAL_FUNCTION_PARAM_PASSTHRU, "selection own", RETURN_TCL); }
/* }}} */

/* {{{ proto mixed Tk_Send(...)
 */
PHP_FUNCTION(za_tk_send) {
	php_tk_global_function(INTERNAL_FUNCTION_PARAM_PASSTHRU, "send", RETURN_TCL); }
/* }}} */

/* {{{ proto mixed Tk_SetPalette(...)
 */
PHP_FUNCTION(za_tk_setpalette) {
	php_tk_global_function(INTERNAL_FUNCTION_PARAM_PASSTHRU, "tk_setpalette", RETURN_TCL); }
/* }}} */

/* {{{ proto mixed Tk_UseInputMethods(...)
 */
PHP_FUNCTION(za_tk_useinputmethods) {
	php_tk_global_function(INTERNAL_FUNCTION_PARAM_PASSTHRU, "tk useinputmethods", RETURN_TCL); }
/* }}} */


/* {{{ GENERATE Tk class functions
 */

/* {{{ proto object new Bitmap(...)
 */
PHP_FUNCTION(za_bitmap) {
	object_init_ex(getThis(), php_tk_bitmap_ce_ptr);
	php_tk_new_widget(INTERNAL_FUNCTION_PARAM_PASSTHRU, "image create bitmap"); 
}
/* }}} */

/* {{{ proto object new Button(...)
 */
PHP_FUNCTION(za_button) {
	object_init_ex(getThis(), php_tk_button_ce_ptr);
	php_tk_new_widget(INTERNAL_FUNCTION_PARAM_PASSTHRU, "button"); 
}
/* }}} */

/* {{{ proto object new Canvas(...)
 */
PHP_FUNCTION(za_canvas) {
	object_init_ex(getThis(), php_tk_canvas_ce_ptr);
	php_tk_new_widget(INTERNAL_FUNCTION_PARAM_PASSTHRU, "canvas"); 
}
/* }}} */

/* {{{ proto object new Checkbutton(...)
 */
PHP_FUNCTION(za_checkbutton) {
	object_init_ex(getThis(), php_tk_checkbutton_ce_ptr);
	php_tk_new_widget(INTERNAL_FUNCTION_PARAM_PASSTHRU, "checkbutton"); 
}
/* }}} */

/* {{{ proto object new Entry(...)
 */
PHP_FUNCTION(za_entry) {
	object_init_ex(getThis(), php_tk_entry_ce_ptr);
	php_tk_new_widget(INTERNAL_FUNCTION_PARAM_PASSTHRU, "entry"); 
}
/* }}} */

/* {{{ proto object new Font(...)
 */
PHP_FUNCTION(za_font) {
	object_init_ex(getThis(), php_tk_font_ce_ptr);
	php_tk_new_widget(INTERNAL_FUNCTION_PARAM_PASSTHRU, "font create"); 
}
/* }}} */

/* {{{ proto object new Frame(...)
 */
PHP_FUNCTION(za_frame) {
	object_init_ex(getThis(), php_tk_frame_ce_ptr);
	php_tk_new_widget(INTERNAL_FUNCTION_PARAM_PASSTHRU, "frame"); 
}
/* }}} */

/* {{{ proto object new Label(...)
 */
PHP_FUNCTION(za_label) {
	object_init_ex(getThis(), php_tk_label_ce_ptr);
	php_tk_new_widget(INTERNAL_FUNCTION_PARAM_PASSTHRU, "label"); 
}
/* }}} */

/* {{{ proto object new Labelframe(...)
 */
PHP_FUNCTION(za_labelframe) {
	object_init_ex(getThis(), php_tk_labelframe_ce_ptr);
	php_tk_new_widget(INTERNAL_FUNCTION_PARAM_PASSTHRU, "labelframe"); 
}
/* }}} */

/* {{{ proto object new Listbox(...)
 */
PHP_FUNCTION(za_listbox) {
	object_init_ex(getThis(), php_tk_listbox_ce_ptr);
	php_tk_new_widget(INTERNAL_FUNCTION_PARAM_PASSTHRU, "listbox"); 
}
/* }}} */

/* {{{ proto object new Menu(...)
 */
PHP_FUNCTION(za_menu) {
	object_init_ex(getThis(), php_tk_menu_ce_ptr);
	php_tk_new_widget(INTERNAL_FUNCTION_PARAM_PASSTHRU, "menu"); 
}
/* }}} */

/* {{{ proto object new Menubutton(...)
 */
PHP_FUNCTION(za_menubutton) {
	object_init_ex(getThis(), php_tk_menubutton_ce_ptr);
	php_tk_new_widget(INTERNAL_FUNCTION_PARAM_PASSTHRU, "menubutton"); 
}
/* }}} */

/* {{{ proto object new Message(...)
 */
PHP_FUNCTION(za_message) {
	object_init_ex(getThis(), php_tk_message_ce_ptr);
	php_tk_new_widget(INTERNAL_FUNCTION_PARAM_PASSTHRU, "message"); 
}
/* }}} */

/* {{{ proto object new Panedwindow(...)
 */
PHP_FUNCTION(za_panedwindow) {
	object_init_ex(getThis(), php_tk_panedwindow_ce_ptr);
	php_tk_new_widget(INTERNAL_FUNCTION_PARAM_PASSTHRU, "panedwindow"); 
}
/* }}} */

/* {{{ proto object new Photo(...)
 */
PHP_FUNCTION(za_photo) {
	object_init_ex(getThis(), php_tk_photo_ce_ptr);
	php_tk_new_widget(INTERNAL_FUNCTION_PARAM_PASSTHRU, "image create photo"); 
}
/* }}} */

/* {{{ proto object new Radiobutton(...)
 */
PHP_FUNCTION(za_radiobutton) {
	object_init_ex(getThis(), php_tk_radiobutton_ce_ptr);
	php_tk_new_widget(INTERNAL_FUNCTION_PARAM_PASSTHRU, "radiobutton"); 
}
/* }}} */

/* {{{ proto object new Scale(...)
 */
PHP_FUNCTION(sc_scale) {
	object_init_ex(getThis(), php_tk_scale_ce_ptr);
	php_tk_new_widget(INTERNAL_FUNCTION_PARAM_PASSTHRU, "scale"); 
}
/* }}} */

/* {{{ proto object new Scrollbar(...)
 */
PHP_FUNCTION(za_scrollbar) {
	object_init_ex(getThis(), php_tk_scrollbar_ce_ptr);
	php_tk_new_widget(INTERNAL_FUNCTION_PARAM_PASSTHRU, "scrollbar"); 
}
/* }}} */

/* {{{ proto object new Spinbox(...)
 */
PHP_FUNCTION(za_spinbox) {
	object_init_ex(getThis(), php_tk_spinbox_ce_ptr);
	php_tk_new_widget(INTERNAL_FUNCTION_PARAM_PASSTHRU, "spinbox"); 
}
/* }}} */

/* {{{ proto object new Text(...)
 */
PHP_FUNCTION(za_text) {
	object_init_ex(getThis(), php_tk_text_ce_ptr);
	php_tk_new_widget(INTERNAL_FUNCTION_PARAM_PASSTHRU, "text"); 
}
/* }}} */

/* {{{ proto object new Textcopy(...)
 */
PHP_FUNCTION(za_textcopy) {
	object_init_ex(getThis(), php_tk_textcopy_ce_ptr);
	php_tk_new_widget(INTERNAL_FUNCTION_PARAM_PASSTHRU, "tk_textcopy"); 
}
/* }}} */

/* {{{ proto object new Textcut(...)
 */
PHP_FUNCTION(za_textcut) {
	object_init_ex(getThis(), php_tk_textcut_ce_ptr);
	php_tk_new_widget(INTERNAL_FUNCTION_PARAM_PASSTHRU, "tk_textcut"); 
}
/* }}} */

/* {{{ proto object new Textpaste(...)
 */
PHP_FUNCTION(za_textpaste) {
	object_init_ex(getThis(), php_tk_textpaste_ce_ptr);
	php_tk_new_widget(INTERNAL_FUNCTION_PARAM_PASSTHRU, "tk_textpaste"); 
}
/* }}} */

/* {{{ proto object new Toplevel(...)
 */
PHP_FUNCTION(za_toplevel) {
	object_init_ex(getThis(), php_tk_toplevel_ce_ptr);
	php_tk_new_widget(INTERNAL_FUNCTION_PARAM_PASSTHRU, "toplevel"); 
}
/* }}} */

/* }}} */


/* {{{ Tk/Images functions
 */
/**/

/* {{{ proto Gfx->delete(Object image, [...])
 */
PHP_FUNCTION(im_delete) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "image delete", GLOBAL_TK, RETURN_EMPTY); }
/* }}} */

/* {{{ proto string Gfx->height(Object gfx)
 */
PHP_FUNCTION(im_height) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "image height", GLOBAL_TK, RETURN_TCL); }
/* }}} */

/* {{{ proto boolean Gfx->inuse(Object gfx)
 */
PHP_FUNCTION(im_inuse) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "image inuse", GLOBAL_TK, RETURN_TCL); }
/* }}} */

/* {{{ proto string Gfx->type(Object gfx)
 */
PHP_FUNCTION(im_type) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "image type", GLOBAL_TK, RETURN_TCL); }
/* }}} */

/* {{{ proto string Gfx->width(Object gfx)
 */
PHP_FUNCTION(im_width) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "image type", GLOBAL_TK, RETURN_TCL); }
/* }}} */

/**/
/* }}} */

/* {{{ Tk/Fonts functions
 */
/**/

/* {{{ proto string Font->actual(Object font, [...])
 */
PHP_FUNCTION(ft_actual) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "font actual", GLOBAL_TK, RETURN_TCL); }
/* }}} */

/* {{{ proto mixed Font->configure(String option, [...])
 */
PHP_FUNCTION(ft_configure) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "font configure", GLOBAL_TK, RETURN_TCL); }
/* }}} */

/* {{{ proto Font->delete(Object font, [...])
 */
PHP_FUNCTION(ft_delete) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "font delete", GLOBAL_TK, RETURN_EMPTY); }
/* }}} */

/* {{{ proto string Font->measure(Object font, [...], String text)
 */
PHP_FUNCTION(ft_measure) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "font measure", GLOBAL_TK, RETURN_TCL); }
/* }}} */

/* {{{ proto string Font->metrics(Object font, [...])
 */
PHP_FUNCTION(ft_metrics) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "font metrics", GLOBAL_TK, RETURN_TCL); }
/* }}} */

/**/
/* }}} */


/* {{{ GENERATE Tk function of class
 */
 
/* {{{ proto mixed Obj->activate(...)
 */
PHP_FUNCTION(za_activate) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "activate", LOCAL_TK, RETURN_TCL); }
/* }}} */

/* {{{ proto  Obj->add(...)
 */
PHP_FUNCTION(za_add) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "add", LOCAL_TK, RETURN_EMPTY); }
/* }}} */

/* {{{ proto mixed Obj->addtag(...)
 */
PHP_FUNCTION(za_addtag) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "addtag", LOCAL_TK, RETURN_TCL); }
/* }}} */

/* {{{ proto mixed Obj->bbox(...)
 */
PHP_FUNCTION(za_bbox) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "bbox", LOCAL_TK, RETURN_TCL); }
/* }}} */

/* {{{ proto  Obj->bell(...)
 */
PHP_FUNCTION(za_bell) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "bell", GLOBAL_TK, RETURN_EMPTY); }
/* }}} */

/* {{{ proto mixed Obj->bind(...)
 */
PHP_FUNCTION(za_bind) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "bind", GLOBAL_TK, RETURN_TCL); }
/* }}} */

/* {{{ proto  Obj->bindtags(...)
 */
PHP_FUNCTION(za_bindtags) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "bindtags", GLOBAL_TK, RETURN_EMPTY); }
/* }}} */

/* {{{ proto  Obj->blank(...)
 */
PHP_FUNCTION(za_blank) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "blank", LOCAL_TK, RETURN_EMPTY); }
/* }}} */

/* {{{ proto mixed Obj->canvasx(...)
 */
PHP_FUNCTION(za_canvasx) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "canvasx", LOCAL_TK, RETURN_TCL); }
/* }}} */

/* {{{ proto mixed Obj->canvasy(...)
 */
PHP_FUNCTION(za_canvasy) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "canvasy", LOCAL_TK, RETURN_TCL); }
/* }}} */

/* {{{ proto mixed Obj->cget(...)
 */
PHP_FUNCTION(za_cget) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "cget", LOCAL_TK, RETURN_TCL); }
/* }}} */

/* {{{ proto  Obj->clipboardAppend(...)
 */
PHP_FUNCTION(za_clipboardappend) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "clipboard append", LOCAL_TK, RETURN_EMPTY); }
/* }}} */

/* {{{ proto  Obj->clipboardClear(...)
 */
PHP_FUNCTION(za_clipboardclear) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "clipboard clear", LOCAL_TK, RETURN_EMPTY); }
/* }}} */

/* {{{ proto mixed Obj->clipboardGet(...)
 */
PHP_FUNCTION(za_clipboardget) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "clipboard get", LOCAL_TK, RETURN_TCL); }
/* }}} */

/* {{{ proto  Obj->clone(...)
 */
PHP_FUNCTION(za_clone) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "clone", LOCAL_TK, RETURN_EMPTY); }
/* }}} */

/* {{{ proto mixed Obj->compare(...)
 */
PHP_FUNCTION(za_compare) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "compare", LOCAL_TK, RETURN_TCL); }
/* }}} */

/* {{{ proto mixed Obj->configure(...)
 */
PHP_FUNCTION(za_configure) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "configure", LOCAL_TK, RETURN_TCL); }
/* }}} */

/* {{{ proto mixed Obj->coords(...)
 */
PHP_FUNCTION(za_coords) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "coords", LOCAL_TK, RETURN_TCL); }
/* }}} */

/* {{{ proto mixed Obj->copy(...)
 */
PHP_FUNCTION(za_copy) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "copy", LOCAL_TK, RETURN_EMPTY); }
/* }}} */

/* {{{ proto mixed Obj->count(...)
 */
PHP_FUNCTION(za_count) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "count", LOCAL_TK, RETURN_TCL); }
/* }}} */

/* {{{ proto mixed Obj->create(...)
 */
PHP_FUNCTION(za_create) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "create", LOCAL_TK, RETURN_TCL); }
/* }}} */

/* {{{ proto mixed Obj->curselection(...)
 */
PHP_FUNCTION(za_curselection) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "curselection", LOCAL_TK, RETURN_TCL); }
/* }}} */

/* {{{ proto mixed Obj->data(...)
 */
PHP_FUNCTION(za_data) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "data", LOCAL_TK, RETURN_TCL); }
/* }}} */

/* {{{ proto  Obj->dchars(...)
 */
PHP_FUNCTION(za_dchars) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "dchars", LOCAL_TK, RETURN_EMPTY); }
/* }}} */

/* {{{ proto mixed Obj->debug(...)
 */
PHP_FUNCTION(za_debug) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "debug", LOCAL_TK, RETURN_TCL); }
/* }}} */

/* {{{ proto  Obj->delete(...)
 */
PHP_FUNCTION(za_delete) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "delete", LOCAL_TK, RETURN_EMPTY); }
/* }}} */

/* {{{ proto mixed Obj->delta(...)
 */
PHP_FUNCTION(za_delta) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "delta", LOCAL_TK, RETURN_TCL); }
/* }}} */

/* {{{ proto  Obj->deselect(...)
 */
PHP_FUNCTION(za_deselect) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "deselect", LOCAL_TK, RETURN_EMPTY); }
/* }}} */

/* {{{ proto  Obj->destroy(...)
 */
PHP_FUNCTION(za_destroy) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "destroy", GLOBAL_TK, RETURN_EMPTY); }
/* }}} */

/* {{{ proto mixed Obj->dlineinfo(...)
 */
PHP_FUNCTION(za_dlineinfo) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "dlineinfo", LOCAL_TK, RETURN_TCL); }
/* }}} */

/* {{{ proto  Obj->dtag(...)
 */
PHP_FUNCTION(za_dtag) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "dtag", LOCAL_TK, RETURN_EMPTY); }
/* }}} */

/* {{{ proto mixed Obj->dump(...)
 */
PHP_FUNCTION(za_dump) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "dump", LOCAL_TK, RETURN_TCL); }
/* }}} */

/* {{{ proto mixed Obj->editModified(...)
 */
PHP_FUNCTION(za_editmodified) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "edit modified", LOCAL_TK, RETURN_TCL); }
/* }}} */

/* {{{ proto  Obj->editRedo(...)
 */
PHP_FUNCTION(za_editredo) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "edit redo", LOCAL_TK, RETURN_EMPTY); }
/* }}} */

/* {{{ proto  Obj->editReset(...)
 */
PHP_FUNCTION(za_editreset) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "edit reset", LOCAL_TK, RETURN_EMPTY); }
/* }}} */

/* {{{ proto  Obj->editSeparator(...)
 */
PHP_FUNCTION(za_editseparator) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "edit separator", LOCAL_TK, RETURN_EMPTY); }
/* }}} */

/* {{{ proto  Obj->editUndo(...)
 */
PHP_FUNCTION(za_editundo) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "edit undo", LOCAL_TK, RETURN_EMPTY); }
/* }}} */

/* {{{ proto mixed Obj->entrycget(...)
 */
PHP_FUNCTION(za_entrycget) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "entrycget", LOCAL_TK, RETURN_TCL); }
/* }}} */

/* {{{ proto mixed Obj->entryconfigure(...)
 */
PHP_FUNCTION(za_entryconfigure) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "entryconfigure", LOCAL_TK, RETURN_TCL); }
/* }}} */

/* {{{ proto mixed Obj->find(...)
 */
PHP_FUNCTION(za_find) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "find", LOCAL_TK, RETURN_TCL); }
/* }}} */

/* {{{ proto  Obj->flash(...)
 */
PHP_FUNCTION(za_flash) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "flash", LOCAL_TK, RETURN_EMPTY); }
/* }}} */

/* {{{ proto mixed Obj->focus(...)
 */
PHP_FUNCTION(za_focus) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "focus", LOCAL_TK, RETURN_TCL); }
/* }}} */

/* {{{ proto  Obj->forget(...)
 */
PHP_FUNCTION(za_forget) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "forget", LOCAL_TK, RETURN_EMPTY); }
/* }}} */

/* {{{ proto mixed Obj->fraction(...)
 */
PHP_FUNCTION(za_fraction) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "fraction", LOCAL_TK, RETURN_TCL); }
/* }}} */

/* {{{ proto mixed Obj->get(...)
 */
PHP_FUNCTION(za_get) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "get", LOCAL_TK, RETURN_TCL); }
/* }}} */

/* {{{ proto mixed Obj->gettags(...)
 */
PHP_FUNCTION(za_gettags) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "gettags", LOCAL_TK, RETURN_TCL); }
/* }}} */

/* {{{ proto  Obj->grab(...)
 */
PHP_FUNCTION(za_grab) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "grab", GLOBAL_TK, RETURN_EMPTY); }
/* }}} */

/* {{{ proto mixed Obj->grabCurrent(...)
 */
PHP_FUNCTION(za_grabcurrent) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "grab current", GLOBAL_TK, RETURN_TCL); }
/* }}} */

/* {{{ proto  Obj->grabRelease(...)
 */
PHP_FUNCTION(za_grabrelease) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "grab release", GLOBAL_TK, RETURN_EMPTY); }
/* }}} */

/* {{{ proto  Obj->grabSet(...)
 */
PHP_FUNCTION(za_grabset) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "grab set", GLOBAL_TK, RETURN_EMPTY); }
/* }}} */

/* {{{ proto mixed Obj->grabStatut(...)
 */
PHP_FUNCTION(za_grabstatut) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "grab statut", GLOBAL_TK, RETURN_TCL); }
/* }}} */

/* {{{ proto  Obj->grid(...)
 */
PHP_FUNCTION(za_grid) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "grid", GLOBAL_TK, RETURN_EMPTY); }
/* }}} */

/* {{{ proto  Obj->gridAnchor(...)
 */
PHP_FUNCTION(za_gridanchor) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "grid anchor", GLOBAL_TK, RETURN_EMPTY); }
/* }}} */

/* {{{ proto mixed Obj->gridBbox(...)
 */
PHP_FUNCTION(za_gridbbox) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "grid bbox", GLOBAL_TK, RETURN_TCL); }
/* }}} */

/* {{{ proto mixed Obj->gridColumnconfigure(...)
 */
PHP_FUNCTION(za_gridcolumnconfigure) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "grid columnconfigure", GLOBAL_TK, RETURN_TCL); }
/* }}} */

/* {{{ proto  Obj->gridConfigure(...)
 */
PHP_FUNCTION(za_gridconfigure) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "grid configure", GLOBAL_TK, RETURN_EMPTY); }
/* }}} */

/* {{{ proto  Obj->gridForget(...)
 */
PHP_FUNCTION(za_gridforget) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "grid forget", GLOBAL_TK, RETURN_EMPTY); }
/* }}} */

/* {{{ proto mixed Obj->gridInfo(...)
 */
PHP_FUNCTION(za_gridinfo) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "grid info", GLOBAL_TK, RETURN_TCL); }
/* }}} */

/* {{{ proto mixed Obj->gridLocation(...)
 */
PHP_FUNCTION(za_gridlocation) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "grid location", GLOBAL_TK, RETURN_TCL); }
/* }}} */

/* {{{ proto mixed Obj->gridPropagate(...)
 */
PHP_FUNCTION(za_gridpropagate) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "grid propagate", GLOBAL_TK, RETURN_TCL); }
/* }}} */

/* {{{ proto  Obj->gridRemove(...)
 */
PHP_FUNCTION(za_gridremove) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "grid remove", GLOBAL_TK, RETURN_EMPTY); }
/* }}} */

/* {{{ proto  Obj->gridRowconfigure(...)
 */
PHP_FUNCTION(za_gridrowconfigure) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "grid rowconfigure", GLOBAL_TK, RETURN_EMPTY); }
/* }}} */

/* {{{ proto mixed Obj->gridSize(...)
 */
PHP_FUNCTION(za_gridsize) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "grid size", GLOBAL_TK, RETURN_TCL); }
/* }}} */

/* {{{ proto mixed Obj->gridSlaves(...)
 */
PHP_FUNCTION(za_gridslaves) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "grid slaves", GLOBAL_TK, RETURN_TCL); }
/* }}} */

/* {{{ proto  Obj->icursor(...)
 */
PHP_FUNCTION(za_icursor) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "icursor", LOCAL_TK, RETURN_EMPTY); }
/* }}} */

/* {{{ proto mixed Obj->identify(...)
 */
PHP_FUNCTION(za_identify) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "identify", LOCAL_TK, RETURN_TCL); }
/* }}} */

/* {{{ proto mixed Obj->imageCget(...)
 */
PHP_FUNCTION(za_imagecget) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "image cget", LOCAL_TK, RETURN_TCL); }
/* }}} */

/* {{{ proto mixed Obj->imageConfigure(...)
 */
PHP_FUNCTION(za_imageconfigure) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "image configure", LOCAL_TK, RETURN_TCL); }
/* }}} */

/* {{{ proto mixed Obj->imageCreate(...)
 */
PHP_FUNCTION(za_imagecreate) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "image create", LOCAL_TK, RETURN_TCL); }
/* }}} */

/* {{{ proto mixed Obj->imageNames(...)
 */
PHP_FUNCTION(za_imagenames) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "image names", LOCAL_TK, RETURN_TCL); }
/* }}} */

/* {{{ proto mixed Obj->index(...)
 */
PHP_FUNCTION(za_index) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "index", LOCAL_TK, RETURN_TCL); }
/* }}} */

/* {{{ proto  Obj->insert(...)
 */
PHP_FUNCTION(za_insert) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "insert", LOCAL_TK, RETURN_EMPTY); }
/* }}} */

/* {{{ proto mixed Obj->invoke(...)
 */
PHP_FUNCTION(za_invoke) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "invoke", LOCAL_TK, RETURN_TCL); }
/* }}} */

/* {{{ proto mixed Obj->itemcget(...)
 */
PHP_FUNCTION(za_itemcget) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "itemcget", LOCAL_TK, RETURN_TCL); }
/* }}} */

/* {{{ proto mixed Obj->itemconfigure(...)
 */
PHP_FUNCTION(za_itemconfigure) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "itemconfigure", LOCAL_TK, RETURN_TCL); }
/* }}} */

/* {{{ proto  Obj->lower(...)
 */
PHP_FUNCTION(za_lower) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "lower", GLOBAL_TK, RETURN_EMPTY); }
/* }}} */

/* {{{ proto mixed Obj->markGravity(...)
 */
PHP_FUNCTION(za_markgravity) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "mark gravity", LOCAL_TK, RETURN_TCL); }
/* }}} */

/* {{{ proto mixed Obj->markNames(...)
 */
PHP_FUNCTION(za_marknames) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "mark names", LOCAL_TK, RETURN_TCL); }
/* }}} */

/* {{{ proto mixed Obj->markNext(...)
 */
PHP_FUNCTION(za_marknext) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "mark next", LOCAL_TK, RETURN_TCL); }
/* }}} */

/* {{{ proto mixed Obj->markPrevious(...)
 */
PHP_FUNCTION(za_markprevious) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "mark previous", LOCAL_TK, RETURN_TCL); }
/* }}} */

/* {{{ proto  Obj->markSet(...)
 */
PHP_FUNCTION(za_markset) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "mark set", LOCAL_TK, RETURN_EMPTY); }
/* }}} */

/* {{{ proto  Obj->markUnset(...)
 */
PHP_FUNCTION(za_markunset) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "mark unset", LOCAL_TK, RETURN_EMPTY); }
/* }}} */

/* {{{ proto  Obj->move(...)
 */
PHP_FUNCTION(za_move) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "move", LOCAL_TK, RETURN_EMPTY); }
/* }}} */

/* {{{ proto mixed Obj->nearest(...)
 */
PHP_FUNCTION(za_nearest) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "nearest", LOCAL_TK, RETURN_TCL); }
/* }}} */

/* {{{ proto  Obj->pack(...)
 */
PHP_FUNCTION(za_pack) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "pack", GLOBAL_TK, RETURN_EMPTY); }
/* }}} */

/* {{{ proto  Obj->packConfigure(...)
 */
PHP_FUNCTION(za_packconfigure) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "pack configure", GLOBAL_TK, RETURN_EMPTY); }
/* }}} */

/* {{{ proto  Obj->packForget(...)
 */
PHP_FUNCTION(za_packforget) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "pack forget", GLOBAL_TK, RETURN_EMPTY); }
/* }}} */

/* {{{ proto mixed Obj->packInfo(...)
 */
PHP_FUNCTION(za_packinfo) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "pack info", GLOBAL_TK, RETURN_TCL); }
/* }}} */

/* {{{ proto mixed Obj->packPropagate(...)
 */
PHP_FUNCTION(za_packpropagate) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "pack propagate", GLOBAL_TK, RETURN_TCL); }
/* }}} */

/* {{{ proto mixed Obj->packSlaves(...)
 */
PHP_FUNCTION(za_packslaves) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "pack slaves", GLOBAL_TK, RETURN_TCL); }
/* }}} */

/* {{{ proto mixed Obj->panecget(...)
 */
PHP_FUNCTION(za_panecget) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "panecget", LOCAL_TK, RETURN_TCL); }
/* }}} */

/* {{{ proto mixed Obj->paneconfigure(...)
 */
PHP_FUNCTION(za_paneconfigure) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "paneconfigure", LOCAL_TK, RETURN_TCL); }
/* }}} */

/* {{{ proto mixed Obj->panes(...)
 */
PHP_FUNCTION(za_panes) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "panes", LOCAL_TK, RETURN_TCL); }
/* }}} */

/* {{{ proto  Obj->place(...)
 */
PHP_FUNCTION(za_place) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "place", GLOBAL_TK, RETURN_EMPTY); }
/* }}} */

/* {{{ proto mixed Obj->placeConfigure(...)
 */
PHP_FUNCTION(za_placeconfigure) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "place configure", GLOBAL_TK, RETURN_TCL); }
/* }}} */

/* {{{ proto  Obj->placeForget(...)
 */
PHP_FUNCTION(za_placeforget) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "place forget", GLOBAL_TK, RETURN_EMPTY); }
/* }}} */

/* {{{ proto mixed Obj->placeInfo(...)
 */
PHP_FUNCTION(za_placeinfo) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "place info", GLOBAL_TK, RETURN_TCL); }
/* }}} */

/* {{{ proto mixed Obj->placeSlaves(...)
 */
PHP_FUNCTION(za_placeslaves) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "place slaves", GLOBAL_TK, RETURN_TCL); }
/* }}} */

/* {{{ proto mixed Obj->post(...)
 */
PHP_FUNCTION(za_post) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "post", LOCAL_TK, RETURN_TCL); }
/* }}} */

/* {{{ proto  Obj->postcascade(...)
 */
PHP_FUNCTION(za_postcascade) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "postcascade", LOCAL_TK, RETURN_EMPTY); }
/* }}} */

/* {{{ proto mixed Obj->postscript(...)
 */
PHP_FUNCTION(za_postscript) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "postscript", LOCAL_TK, RETURN_TCL); }
/* }}} */

/* {{{ proto  Obj->proxy(...)
 */
PHP_FUNCTION(za_proxy) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "proxy", LOCAL_TK, RETURN_EMPTY); }
/* }}} */

/* {{{ proto mixed Obj->proxyCoord(...)
 */
PHP_FUNCTION(za_proxycoord) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "proxy coord", LOCAL_TK, RETURN_TCL); }
/* }}} */

/* {{{ proto  Obj->proxyForget(...)
 */
PHP_FUNCTION(za_proxyforget) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "proxy forget", LOCAL_TK, RETURN_EMPTY); }
/* }}} */

/* {{{ proto  Obj->proxyPlace(...)
 */
PHP_FUNCTION(za_proxyplace) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "proxy place", LOCAL_TK, RETURN_EMPTY); }
/* }}} */

/* {{{ proto  Obj->put(...)
 */
PHP_FUNCTION(za_put) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "put", LOCAL_TK, RETURN_EMPTY); }
/* }}} */

/* {{{ proto  Obj->raise(...)
 */
PHP_FUNCTION(za_raise) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "raise", GLOBAL_TK, RETURN_EMPTY); }
/* }}} */

/* {{{ proto  Obj->read(...)
 */
PHP_FUNCTION(za_read) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "read", LOCAL_TK, RETURN_EMPTY); }
/* }}} */

/* {{{ proto  Obj->redither(...)
 */
PHP_FUNCTION(za_redither) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "redither", LOCAL_TK, RETURN_EMPTY); }
/* }}} */

/* {{{ proto  Obj->replace(...)
 */
PHP_FUNCTION(za_replace) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "replace", LOCAL_TK, RETURN_EMPTY); }
/* }}} */

/* {{{ proto  Obj->sash(...)
 */
PHP_FUNCTION(za_sash) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "sash", LOCAL_TK, RETURN_EMPTY); }
/* }}} */

/* {{{ proto mixed Obj->sashCoord(...)
 */
PHP_FUNCTION(za_sashcoord) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "sash coord", LOCAL_TK, RETURN_TCL); }
/* }}} */

/* {{{ proto  Obj->sashMark(...)
 */
PHP_FUNCTION(za_sashmark) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "sash mark", LOCAL_TK, RETURN_EMPTY); }
/* }}} */

/* {{{ proto  Obj->sashPlace(...)
 */
PHP_FUNCTION(za_sashplace) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "sash place", LOCAL_TK, RETURN_EMPTY); }
/* }}} */

/* {{{ proto  Obj->scale(...)
 */
PHP_FUNCTION(za_scale) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "scale", LOCAL_TK, RETURN_EMPTY); }
/* }}} */

/* {{{ proto  Obj->scanDragto(...)
 */
PHP_FUNCTION(za_scandragto) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "scan dragto", LOCAL_TK, RETURN_EMPTY); }
/* }}} */

/* {{{ proto  Obj->scanMark(...)
 */
PHP_FUNCTION(za_scanmark) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "scan mark", LOCAL_TK, RETURN_EMPTY); }
/* }}} */

/* {{{ proto mixed Obj->search(...)
 */
PHP_FUNCTION(za_search) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "search", LOCAL_TK, RETURN_TCL); }
/* }}} */

/* {{{ proto  Obj->see(...)
 */
PHP_FUNCTION(za_see) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "see", LOCAL_TK, RETURN_EMPTY); }
/* }}} */

/* {{{ proto  Obj->selectAdjust(...)
 */
PHP_FUNCTION(za_selectadjust) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "select adjust", LOCAL_TK, RETURN_EMPTY); }
/* }}} */

/* {{{ proto  Obj->selectClear(...)
 */
PHP_FUNCTION(za_selectclear) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "select clear", LOCAL_TK, RETURN_EMPTY); }
/* }}} */

/* {{{ proto  Obj->selectFrom(...)
 */
PHP_FUNCTION(za_selectfrom) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "select from", LOCAL_TK, RETURN_EMPTY); }
/* }}} */

/* {{{ proto mixed Obj->selectItem(...)
 */
PHP_FUNCTION(za_selectitem) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "select item", LOCAL_TK, RETURN_TCL); }
/* }}} */

/* {{{ proto  Obj->selectTo(...)
 */
PHP_FUNCTION(za_selectto) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "select to", LOCAL_TK, RETURN_EMPTY); }
/* }}} */

/* {{{ proto  Obj->selectionAdjust(...)
 */
PHP_FUNCTION(za_selectionadjust) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "selection adjust", LOCAL_TK, RETURN_EMPTY); }
/* }}} */

/* {{{ proto  Obj->selectionAnchor(...)
 */
PHP_FUNCTION(za_selectionanchor) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "selection anchor", LOCAL_TK, RETURN_EMPTY); }
/* }}} */

/* {{{ proto  Obj->selectionClear(...)
 */
PHP_FUNCTION(za_selectionclear) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "selection clear", LOCAL_TK, RETURN_EMPTY); }
/* }}} */

/* {{{ proto mixed Obj->selectionElement(...)
 */
PHP_FUNCTION(za_selectionelement) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "selection element", LOCAL_TK, RETURN_TCL); }
/* }}} */

/* {{{ proto  Obj->selectionFrom(...)
 */
PHP_FUNCTION(za_selectionfrom) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "selection from", LOCAL_TK, RETURN_EMPTY); }
/* }}} */

/* {{{ proto mixed Obj->selectionIncludes(...)
 */
PHP_FUNCTION(za_selectionincludes) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "selection includes", LOCAL_TK, RETURN_TCL); }
/* }}} */

/* {{{ proto mixed Obj->selectionPresent(...)
 */
PHP_FUNCTION(za_selectionpresent) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "selection present", LOCAL_TK, RETURN_TCL); }
/* }}} */

/* {{{ proto  Obj->selectionRange(...)
 */
PHP_FUNCTION(za_selectionrange) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "selection range", LOCAL_TK, RETURN_EMPTY); }
/* }}} */

/* {{{ proto  Obj->selectionSet(...)
 */
PHP_FUNCTION(za_selectionset) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "selection set", LOCAL_TK, RETURN_EMPTY); }
/* }}} */

/* {{{ proto  Obj->selectionTo(...)
 */
PHP_FUNCTION(za_selectionto) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "selection to", LOCAL_TK, RETURN_EMPTY); }
/* }}} */

/* {{{ proto  Obj->set(...)
 */
PHP_FUNCTION(za_set) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "set", LOCAL_TK, RETURN_EMPTY); }
/* }}} */

/* {{{ proto mixed Obj->size(...)
 */
PHP_FUNCTION(za_size) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "size", LOCAL_TK, RETURN_TCL); }
/* }}} */

/* {{{ proto  Obj->tagAdd(...)
 */
PHP_FUNCTION(za_tagadd) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "tag add", LOCAL_TK, RETURN_EMPTY); }
/* }}} */

/* {{{ proto mixed Obj->tagBind(...)
 */
PHP_FUNCTION(za_tagbind) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "tag bind", LOCAL_TK, RETURN_TCL); }
/* }}} */

/* {{{ proto mixed Obj->tagCget(...)
 */
PHP_FUNCTION(za_tagcget) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "tag cget", LOCAL_TK, RETURN_TCL); }
/* }}} */

/* {{{ proto mixed Obj->tagConfigure(...)
 */
PHP_FUNCTION(za_tagconfigure) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "tag configure", LOCAL_TK, RETURN_TCL); }
/* }}} */

/* {{{ proto  Obj->tagDelete(...)
 */
PHP_FUNCTION(za_tagdelete) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "tag delete", LOCAL_TK, RETURN_EMPTY); }
/* }}} */

/* {{{ proto  Obj->tagLower(...)
 */
PHP_FUNCTION(za_taglower) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "tag lower", LOCAL_TK, RETURN_EMPTY); }
/* }}} */

/* {{{ proto mixed Obj->tagNames(...)
 */
PHP_FUNCTION(za_tagnames) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "tag names", LOCAL_TK, RETURN_TCL); }
/* }}} */

/* {{{ proto mixed Obj->tagNextrange(...)
 */
PHP_FUNCTION(za_tagnextrange) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "tag nextrange", LOCAL_TK, RETURN_TCL); }
/* }}} */

/* {{{ proto mixed Obj->tagPrevrange(...)
 */
PHP_FUNCTION(za_tagprevrange) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "tag prevrange", LOCAL_TK, RETURN_TCL); }
/* }}} */

/* {{{ proto  Obj->tagRaise(...)
 */
PHP_FUNCTION(za_tagraise) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "tag raise", LOCAL_TK, RETURN_EMPTY); }
/* }}} */

/* {{{ proto mixed Obj->tagRanges(...)
 */
PHP_FUNCTION(za_tagranges) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "tag ranges", LOCAL_TK, RETURN_TCL); }
/* }}} */

/* {{{ proto  Obj->tagRemove(...)
 */
PHP_FUNCTION(za_tagremove) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "tag remove", LOCAL_TK, RETURN_EMPTY); }
/* }}} */

/* {{{ proto  Obj->toggle(...)
 */
PHP_FUNCTION(za_toggle) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "toggle", LOCAL_TK, RETURN_EMPTY); }
/* }}} */

/* {{{ proto mixed Obj->transparencyGet(...)
 */
PHP_FUNCTION(za_transparencyget) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "transparency get", LOCAL_TK, RETURN_TCL); }
/* }}} */

/* {{{ proto mixed Obj->transparencySet(...)
 */
PHP_FUNCTION(za_transparencyset) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "transparency set", LOCAL_TK, RETURN_EMPTY); }
/* }}} */

/* {{{ proto mixed Obj->type(...)
 */
PHP_FUNCTION(za_type) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "type", LOCAL_TK, RETURN_TCL); }
/* }}} */

/* {{{ proto  Obj->unpost(...)
 */
PHP_FUNCTION(za_unpost) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "unpost", LOCAL_TK, RETURN_EMPTY); }
/* }}} */

/* {{{ proto mixed Obj->validate(...)
 */
PHP_FUNCTION(za_validate) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "validate", LOCAL_TK, RETURN_TCL); }
/* }}} */

/* {{{ proto mixed Obj->windowCget(...)
 */
PHP_FUNCTION(za_windowcget) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "window cget", LOCAL_TK, RETURN_TCL); }
/* }}} */

/* {{{ proto mixed Obj->windowConfigure(...)
 */
PHP_FUNCTION(za_windowconfigure) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "window configure", LOCAL_TK, RETURN_TCL); }
/* }}} */

/* {{{ proto  Obj->windowCreate(...)
 */
PHP_FUNCTION(za_windowcreate) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "window create", LOCAL_TK, RETURN_EMPTY); }
/* }}} */

/* {{{ proto mixed Obj->windowNames(...)
 */
PHP_FUNCTION(za_windownames) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "window names", LOCAL_TK, RETURN_TCL); }
/* }}} */

/* {{{ proto mixed Obj->wmAspect(...)
 */
PHP_FUNCTION(za_wmaspect) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "wm aspect", GLOBAL_TK, RETURN_TCL); }
/* }}} */

/* {{{ proto mixed Obj->wmAttributes(...)
 */
PHP_FUNCTION(za_wmattributes) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "wm attributes", GLOBAL_TK, RETURN_TCL); }
/* }}} */

/* {{{ proto  Obj->wmClient(...)
 */
PHP_FUNCTION(za_wmclient) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "wm client", GLOBAL_TK, RETURN_EMPTY); }
/* }}} */

/* {{{ proto  Obj->wmColormapwindows(...)
 */
PHP_FUNCTION(za_wmcolormapwindows) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "wm colormapwindows", GLOBAL_TK, RETURN_EMPTY); }
/* }}} */

/* {{{ proto mixed Obj->wmCommand(...)
 */
PHP_FUNCTION(za_wmcommand) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "wm command", GLOBAL_TK, RETURN_TCL); }
/* }}} */

/* {{{ proto  Obj->wmDeiconify(...)
 */
PHP_FUNCTION(za_wmdeiconify) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "wm deiconify", GLOBAL_TK, RETURN_EMPTY); }
/* }}} */

/* {{{ proto mixed Obj->wmFocusmodel(...)
 */
PHP_FUNCTION(za_wmfocusmodel) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "wm focusmodel", GLOBAL_TK, RETURN_TCL); }
/* }}} */

/* {{{ proto mixed Obj->wmFrame(...)
 */
PHP_FUNCTION(za_wmframe) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "wm frame", GLOBAL_TK, RETURN_TCL); }
/* }}} */

/* {{{ proto mixed Obj->wmGeometry(...)
 */
PHP_FUNCTION(za_wmgeometry) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "wm geometry", GLOBAL_TK, RETURN_TCL); }
/* }}} */

/* {{{ proto mixed Obj->wmGrid(...)
 */
PHP_FUNCTION(za_wmgrid) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "wm grid", GLOBAL_TK, RETURN_TCL); }
/* }}} */

/* {{{ proto mixed Obj->wmGroup(...)
 */
PHP_FUNCTION(za_wmgroup) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "wm group", GLOBAL_TK, RETURN_TCL); }
/* }}} */

/* {{{ proto mixed Obj->wmIconbitmap(...)
 */
PHP_FUNCTION(za_wmiconbitmap) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "wm iconbitmap", GLOBAL_TK, RETURN_TCL); }
/* }}} */

/* {{{ proto  Obj->wmIconify(...)
 */
PHP_FUNCTION(za_wmiconify) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "wm iconify", GLOBAL_TK, RETURN_EMPTY); }
/* }}} */

/* {{{ proto mixed Obj->wmIconmask(...)
 */
PHP_FUNCTION(za_wmiconmask) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "wm iconmask", GLOBAL_TK, RETURN_TCL); }
/* }}} */

/* {{{ proto mixed Obj->wmIconname(...)
 */
PHP_FUNCTION(za_wmiconname) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "wm iconname", GLOBAL_TK, RETURN_TCL); }
/* }}} */

/* {{{ proto mixed Obj->wmIconposition(...)
 */
PHP_FUNCTION(za_wmiconposition) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "wm iconposition", GLOBAL_TK, RETURN_TCL); }
/* }}} */

/* {{{ proto mixed Obj->wmIconwindow(...)
 */
PHP_FUNCTION(za_wmiconwindow) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "wm iconwindow", GLOBAL_TK, RETURN_TCL); }
/* }}} */

/* {{{ proto mixed Obj->wmMaxsize(...)
 */
PHP_FUNCTION(za_wmmaxsize) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "wm maxsize", GLOBAL_TK, RETURN_TCL); }
/* }}} */

/* {{{ proto mixed Obj->wmMinsize(...)
 */
PHP_FUNCTION(za_wmminsize) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "wm minsize", GLOBAL_TK, RETURN_TCL); }
/* }}} */

/* {{{ proto mixed Obj->wmOverrideredirect(...)
 */
PHP_FUNCTION(za_wmoverrideredirect) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "wm overrideredirect", GLOBAL_TK, RETURN_TCL); }
/* }}} */

/* {{{ proto mixed Obj->wmPositionfrom(...)
 */
PHP_FUNCTION(za_wmpositionfrom) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "wm positionfrom", GLOBAL_TK, RETURN_TCL); }
/* }}} */

/* {{{ proto mixed Obj->wmProtocol(...)
 */
PHP_FUNCTION(za_wmprotocol) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "wm protocol", GLOBAL_TK, RETURN_TCL); }
/* }}} */

/* {{{ proto mixed Obj->wmResizable(...)
 */
PHP_FUNCTION(za_wmresizable) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "wm resizable", GLOBAL_TK, RETURN_TCL); }
/* }}} */

/* {{{ proto mixed Obj->wmSizefrom(...)
 */
PHP_FUNCTION(za_wmsizefrom) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "wm sizefrom", GLOBAL_TK, RETURN_TCL); }
/* }}} */

/* {{{ proto mixed Obj->wmStackorder(...)
 */
PHP_FUNCTION(za_wmstackorder) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "wm stackorder", GLOBAL_TK, RETURN_TCL); }
/* }}} */

/* {{{ proto mixed Obj->wmState(...)
 */
PHP_FUNCTION(za_wmstate) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "wm state", GLOBAL_TK, RETURN_TCL); }
/* }}} */

/* {{{ proto mixed Obj->wmTitle(...)
 */
PHP_FUNCTION(za_wmtitle) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "wm title", GLOBAL_TK, RETURN_TCL); }
/* }}} */

/* {{{ proto mixed Obj->wmTransient(...)
 */
PHP_FUNCTION(za_wmtransient) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "wm transient", GLOBAL_TK, RETURN_TCL); }
/* }}} */

/* {{{ proto mixed Obj->wmWithdraw(...)
 */
PHP_FUNCTION(za_wmwithdraw) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "wm withdraw", GLOBAL_TK, RETURN_TCL); }
/* }}} */

/* {{{ proto Obj->write(...)
 */
PHP_FUNCTION(za_write) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "write", LOCAL_TK, RETURN_EMPTY); }
/* }}} */

/* {{{ proto mixed Obj->xview(...)
 */
PHP_FUNCTION(za_xview) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "xview", LOCAL_TK, RETURN_TCL); }
/* }}} */

/* {{{ proto  Obj->xviewMoveto(...)
 */
PHP_FUNCTION(za_xviewmoveto) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "xview moveto", LOCAL_TK, RETURN_EMPTY); }
/* }}} */

/* {{{ proto  Obj->xviewScroll(...)
 */
PHP_FUNCTION(za_xviewscroll) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "xview scroll", LOCAL_TK, RETURN_EMPTY); }
/* }}} */

/* {{{ proto mixed Obj->yposition(...)
 */
PHP_FUNCTION(za_yposition) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "yposition", LOCAL_TK, RETURN_TCL); }
/* }}} */

/* {{{ proto mixed Obj->yview(...)
 */
PHP_FUNCTION(za_yview) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "yview", LOCAL_TK, RETURN_TCL); }
/* }}} */

/* {{{ proto  Obj->yviewMoveto(...)
 */
PHP_FUNCTION(za_yviewmoveto) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "yview moveto", LOCAL_TK, RETURN_EMPTY); }
/* }}} */

/* {{{ proto  Obj->yviewScroll(...)
 */
PHP_FUNCTION(za_yviewscroll) {
	php_tk_widget_command(INTERNAL_FUNCTION_PARAM_PASSTHRU, "yview scroll", LOCAL_TK, RETURN_EMPTY); }
/* }}} */

/* }}} */

/* }}} */

/*
#endif	HAVE_PTHREAD_LIB
*/

/*
 * Local variables:
 * tab-width: 4
 * c-basic-offset: 4
 * End:
 * vim600: noet sw=4 ts=4 fdm=marker
 * vim<600: noet sw=4 ts=4
 */
