/*
  +----------------------------------------------------------------------+
  | PHP Version 5                                                        |
  +----------------------------------------------------------------------+
  | Copyright (c) 1999-2004 The PHP Group                                |
  +----------------------------------------------------------------------+
  | This source file is subject to version 3.0 of the PHP license,       |
  | that is bundled with this package in the file LICENSE, and is        |
  | available at through the world-wide-web at                           |
  | http://www.php.net/license/3_0.txt.                                  |
  | If you did not receive a copy of the PHP license and are unable to   |
  | obtain it through the world-wide-web, please send a note to          |
  | license@php.net so we can mail you a copy immediately.               |
  +----------------------------------------------------------------------+
  | Authors: Mathieu Hurtevent <ut0pia@users.sourceforge.net>            |
  +----------------------------------------------------------------------+
*/

#ifndef PHP_TK_H
#define PHP_TK_H

/*
#if HAVE_PTHREAD_LIB
*/

#include <pthread.h>

extern zend_module_entry php_tk_api_module_entry;
#define phpext_tk_ptr &php_tk_api_module_entry

#define PHP_TK_API
#ifdef PHP_WIN32
#undef PHP_TK_API
#ifdef TK_EXPORTS
#define PHP_TK_API __declspec(dllexport)
#else
#define PHP_TK_API __declspec(dllimport)
#endif
#endif

/* {{{ macro
 */
#define LOCAL_TK 1
#define GLOBAL_TK 0

#define RETURN_EMPTY 0
#define RETURN_TCL 1
#define RETURN_WIDGET 2

#define PARAM_TK_CMD char *c
#define PARAM_TK_TYPE int t
#define PARAM_TK_RETURN int r
#define TK_CMD c
#define TK_TYPE t
#define TK_RETURN r

#define FREE_STRUCT(phpList) \
	efree ((phpList)->val_token); \
	efree ((phpList)->ref_tokens); \
	efree ((phpList));
/* }}} */

/* {{{ definition of the structures
 */

typedef struct {
	int debug;
	int exit;
	int loaded;
	int widget_assign;
	struct {
		FILE *p_in;
		FILE *p_out;
		FILE *p_event;
	} flux;
/**/
	pthread_t thread;
/**/
} globals_php_tk;

globals_php_tk tmp_struct;
globals_php_tk *php_tk = &tmp_struct;

typedef struct {
	char *ref_tokens, *val_token;
	int count_tokens;
} php_split;

/* }}} */

/* {{{ declaraion of the standard C functions
 */

/* functions to generate commands
 */
static void php_tk_new_widget(INTERNAL_FUNCTION_PARAMETERS, PARAM_TK_CMD);
static void php_tk_widget_command(INTERNAL_FUNCTION_PARAMETERS, PARAM_TK_CMD, PARAM_TK_TYPE, PARAM_TK_RETURN);
static void php_tk_global_function(INTERNAL_FUNCTION_PARAMETERS, PARAM_TK_CMD, PARAM_TK_RETURN);
static void php_tk_terminal(zval *return_value, PARAM_TK_CMD, PARAM_TK_RETURN);

/* interfacing with TCL/TK
 */
static void *php_tk_trace_event();
static int php_tk_addslashes(zval *return_value, char *p_string);
static void php_tcl_list_to_array (zval **new_array, char *tcl_list);

/* System functions
 */
static int php_get_line (char **r_string, FILE *flux);
static int php_popen (char *exec_path);

/* treatment of string
 */
static void php_strncpy (char **p_string, int start, int len);
static int php_strncmp (char **b_string, char *c_string, int offset);
static int php_strchr (char **p_string, char pattern);
static php_split *php_make_split (char pattern, char **r_string);
static php_split *php_get_split (char **r_string, int p_index, php_split *p_split);

/* {{{ declaration of the global functions
 */
PHP_MINIT_FUNCTION(php_tk);
PHP_MSHUTDOWN_FUNCTION(php_tk);
PHP_RSHUTDOWN_FUNCTION(php_tk);
PHP_MINFO_FUNCTION(php_tk);

PHP_FUNCTION(za_tk_mainloop);
PHP_FUNCTION(za_tk_exit);
PHP_FUNCTION(za_tk_callback);
PHP_FUNCTION(za_tk_debug);
PHP_FUNCTION(za_tk_shell);

PHP_FUNCTION(za_tk_addslashes);
PHP_FUNCTION(za_tcl_listtoarray);

PHP_FUNCTION(za_tk_appname);
PHP_FUNCTION(za_tk_bisque);
PHP_FUNCTION(za_tk_choosecolor);
PHP_FUNCTION(za_tk_choosedirectory);
PHP_FUNCTION(za_tk_dialog);
PHP_FUNCTION(za_tk_eventadd);
PHP_FUNCTION(za_tk_eventdelete);
PHP_FUNCTION(za_tk_eventgenerate);
PHP_FUNCTION(za_tk_eventinfo);
PHP_FUNCTION(za_tk_focusfollowsmouse);
PHP_FUNCTION(za_tk_focusnext);
PHP_FUNCTION(za_tk_focusprev);
PHP_FUNCTION(za_tk_fontfamilies);
PHP_FUNCTION(za_tk_fontnames);
PHP_FUNCTION(za_tk_getopenfile);
PHP_FUNCTION(za_tk_getsavefile);
PHP_FUNCTION(za_tk_imageinuse);
PHP_FUNCTION(za_tk_imagenames);
PHP_FUNCTION(za_tk_imagetypes);
PHP_FUNCTION(za_tk_messagebox);
PHP_FUNCTION(za_tk_optionadd);
PHP_FUNCTION(za_tk_optionclear);
PHP_FUNCTION(za_tk_optionget);
PHP_FUNCTION(za_tk_optionmenu);
PHP_FUNCTION(za_tk_optionreadfile);
PHP_FUNCTION(za_tk_popup);
PHP_FUNCTION(za_tk_scaling);
PHP_FUNCTION(za_tk_selectionclear);
PHP_FUNCTION(za_tk_selectionget);
PHP_FUNCTION(za_tk_selectionhandle);
PHP_FUNCTION(za_tk_selectionown);
PHP_FUNCTION(za_tk_send);
PHP_FUNCTION(za_tk_setpalette);
PHP_FUNCTION(za_tk_useinputmethods);
/* }}} */

/* {{{ declaration of the class
 */
PHP_FUNCTION(za_tk);
PHP_FUNCTION(za_bitmap);
PHP_FUNCTION(za_button);
PHP_FUNCTION(za_canvas);
PHP_FUNCTION(za_checkbutton);
PHP_FUNCTION(za_entry);
PHP_FUNCTION(za_font);
PHP_FUNCTION(za_frame);
PHP_FUNCTION(za_label);
PHP_FUNCTION(za_labelframe);
PHP_FUNCTION(za_listbox);
PHP_FUNCTION(za_menu);
PHP_FUNCTION(za_menubutton);
PHP_FUNCTION(za_message);
PHP_FUNCTION(za_panedwindow);
PHP_FUNCTION(za_photo);
PHP_FUNCTION(za_radiobutton);
PHP_FUNCTION(sc_scale);
PHP_FUNCTION(za_scrollbar);
PHP_FUNCTION(za_spinbox);
PHP_FUNCTION(za_text);
PHP_FUNCTION(za_textcopy);
PHP_FUNCTION(za_textcut);
PHP_FUNCTION(za_textpaste);
PHP_FUNCTION(za_toplevel);
/* }}} */

/* {{{ declaration of image functions
 */
PHP_FUNCTION(im_delete);
PHP_FUNCTION(im_height);
PHP_FUNCTION(im_inuse);
PHP_FUNCTION(im_type);
PHP_FUNCTION(im_width);
/* }}} */

/* {{{ declaration of font functions
 */
PHP_FUNCTION(ft_actual);
PHP_FUNCTION(ft_configure);
PHP_FUNCTION(ft_delete);
PHP_FUNCTION(ft_measure);
PHP_FUNCTION(ft_metrics);
/* }}} */

/* {{{ declaration of the functions class
 */
PHP_FUNCTION(za_getid);
PHP_FUNCTION(za_activate);
PHP_FUNCTION(za_add);
PHP_FUNCTION(za_addtag);
PHP_FUNCTION(za_bbox);
PHP_FUNCTION(za_bell);
PHP_FUNCTION(za_bind);
PHP_FUNCTION(za_bindtags);
PHP_FUNCTION(za_blank);
PHP_FUNCTION(za_canvasx);
PHP_FUNCTION(za_canvasy);
PHP_FUNCTION(za_cget);
PHP_FUNCTION(za_clipboardappend);
PHP_FUNCTION(za_clipboardclear);
PHP_FUNCTION(za_clipboardget);
PHP_FUNCTION(za_clone);
PHP_FUNCTION(za_compare);
PHP_FUNCTION(za_configure);
PHP_FUNCTION(za_coords);
PHP_FUNCTION(za_count);
PHP_FUNCTION(za_copy);
PHP_FUNCTION(za_create);
PHP_FUNCTION(za_curselection);
PHP_FUNCTION(za_data);
PHP_FUNCTION(za_dchars);
PHP_FUNCTION(za_debug);
PHP_FUNCTION(za_delete);
PHP_FUNCTION(za_delta);
PHP_FUNCTION(za_deselect);
PHP_FUNCTION(za_destroy);
PHP_FUNCTION(za_dlineinfo);
PHP_FUNCTION(za_dtag);
PHP_FUNCTION(za_dump);
PHP_FUNCTION(za_editmodified);
PHP_FUNCTION(za_editredo);
PHP_FUNCTION(za_editreset);
PHP_FUNCTION(za_editseparator);
PHP_FUNCTION(za_editundo);
PHP_FUNCTION(za_entrycget);
PHP_FUNCTION(za_entryconfigure);
PHP_FUNCTION(za_find);
PHP_FUNCTION(za_flash);
PHP_FUNCTION(za_focus);
PHP_FUNCTION(za_forget);
PHP_FUNCTION(za_fraction);
PHP_FUNCTION(za_get);
PHP_FUNCTION(za_gettags);
PHP_FUNCTION(za_grab);
PHP_FUNCTION(za_grabcurrent);
PHP_FUNCTION(za_grabrelease);
PHP_FUNCTION(za_grabset);
PHP_FUNCTION(za_grabstatut);
PHP_FUNCTION(za_grid);
PHP_FUNCTION(za_gridanchor);
PHP_FUNCTION(za_gridbbox);
PHP_FUNCTION(za_gridcolumnconfigure);
PHP_FUNCTION(za_gridconfigure);
PHP_FUNCTION(za_gridforget);
PHP_FUNCTION(za_gridinfo);
PHP_FUNCTION(za_gridlocation);
PHP_FUNCTION(za_gridpropagate);
PHP_FUNCTION(za_gridremove);
PHP_FUNCTION(za_gridrowconfigure);
PHP_FUNCTION(za_gridsize);
PHP_FUNCTION(za_gridslaves);
PHP_FUNCTION(za_icursor);
PHP_FUNCTION(za_identify);
PHP_FUNCTION(za_imagecget);
PHP_FUNCTION(za_imageconfigure);
PHP_FUNCTION(za_imagecreate);
PHP_FUNCTION(za_imagenames);
PHP_FUNCTION(za_index);
PHP_FUNCTION(za_insert);
PHP_FUNCTION(za_invoke);
PHP_FUNCTION(za_itemcget);
PHP_FUNCTION(za_itemconfigure);
PHP_FUNCTION(za_lower);
PHP_FUNCTION(za_markgravity);
PHP_FUNCTION(za_marknames);
PHP_FUNCTION(za_marknext);
PHP_FUNCTION(za_markprevious);
PHP_FUNCTION(za_markset);
PHP_FUNCTION(za_markunset);
PHP_FUNCTION(za_move);
PHP_FUNCTION(za_nearest);
PHP_FUNCTION(za_pack);
PHP_FUNCTION(za_packconfigure);
PHP_FUNCTION(za_packforget);
PHP_FUNCTION(za_packinfo);
PHP_FUNCTION(za_packpropagate);
PHP_FUNCTION(za_packslaves);
PHP_FUNCTION(za_panecget);
PHP_FUNCTION(za_paneconfigure);
PHP_FUNCTION(za_panes);
PHP_FUNCTION(za_place);
PHP_FUNCTION(za_placeconfigure);
PHP_FUNCTION(za_placeforget);
PHP_FUNCTION(za_placeinfo);
PHP_FUNCTION(za_placeslaves);
PHP_FUNCTION(za_post);
PHP_FUNCTION(za_postcascade);
PHP_FUNCTION(za_postscript);
PHP_FUNCTION(za_proxy);
PHP_FUNCTION(za_proxycoord);
PHP_FUNCTION(za_proxyforget);
PHP_FUNCTION(za_proxyplace);
PHP_FUNCTION(za_put);
PHP_FUNCTION(za_raise);
PHP_FUNCTION(za_read);
PHP_FUNCTION(za_redither);
PHP_FUNCTION(za_replace);
PHP_FUNCTION(za_sash);
PHP_FUNCTION(za_sashcoord);
PHP_FUNCTION(za_sashmark);
PHP_FUNCTION(za_sashplace);
PHP_FUNCTION(za_scale);
PHP_FUNCTION(za_scandragto);
PHP_FUNCTION(za_scanmark);
PHP_FUNCTION(za_search);
PHP_FUNCTION(za_see);
PHP_FUNCTION(za_selectadjust);
PHP_FUNCTION(za_selectclear);
PHP_FUNCTION(za_selectfrom);
PHP_FUNCTION(za_selectitem);
PHP_FUNCTION(za_selectto);
PHP_FUNCTION(za_selectionadjust);
PHP_FUNCTION(za_selectionanchor);
PHP_FUNCTION(za_selectionclear);
PHP_FUNCTION(za_selectionelement);
PHP_FUNCTION(za_selectionfrom);
PHP_FUNCTION(za_selectionincludes);
PHP_FUNCTION(za_selectionpresent);
PHP_FUNCTION(za_selectionrange);
PHP_FUNCTION(za_selectionset);
PHP_FUNCTION(za_selectionto);
PHP_FUNCTION(za_set);
PHP_FUNCTION(za_size);
PHP_FUNCTION(za_tagadd);
PHP_FUNCTION(za_tagbind);
PHP_FUNCTION(za_tagcget);
PHP_FUNCTION(za_tagconfigure);
PHP_FUNCTION(za_tagdelete);
PHP_FUNCTION(za_taglower);
PHP_FUNCTION(za_tagnames);
PHP_FUNCTION(za_tagnextrange);
PHP_FUNCTION(za_tagprevrange);
PHP_FUNCTION(za_tagraise);
PHP_FUNCTION(za_tagranges);
PHP_FUNCTION(za_tagremove);
PHP_FUNCTION(za_toggle);
PHP_FUNCTION(za_transparencyget);
PHP_FUNCTION(za_transparencyset);
PHP_FUNCTION(za_type);
PHP_FUNCTION(za_unpost);
PHP_FUNCTION(za_validate);
PHP_FUNCTION(za_windowcget);
PHP_FUNCTION(za_windowconfigure);
PHP_FUNCTION(za_windowcreate);
PHP_FUNCTION(za_windownames);
PHP_FUNCTION(za_wmaspect);
PHP_FUNCTION(za_wmattributes);
PHP_FUNCTION(za_wmclient);
PHP_FUNCTION(za_wmcolormapwindows);
PHP_FUNCTION(za_wmcommand);
PHP_FUNCTION(za_wmdeiconify);
PHP_FUNCTION(za_wmfocusmodel);
PHP_FUNCTION(za_wmframe);
PHP_FUNCTION(za_wmgeometry);
PHP_FUNCTION(za_wmgrid);
PHP_FUNCTION(za_wmgroup);
PHP_FUNCTION(za_wmiconbitmap);
PHP_FUNCTION(za_wmiconify);
PHP_FUNCTION(za_wmiconmask);
PHP_FUNCTION(za_wmiconname);
PHP_FUNCTION(za_wmiconposition);
PHP_FUNCTION(za_wmiconwindow);
PHP_FUNCTION(za_wmmaxsize);
PHP_FUNCTION(za_wmminsize);
PHP_FUNCTION(za_wmoverrideredirect);
PHP_FUNCTION(za_wmpositionfrom);
PHP_FUNCTION(za_wmprotocol);
PHP_FUNCTION(za_wmresizable);
PHP_FUNCTION(za_wmsizefrom);
PHP_FUNCTION(za_wmstackorder);
PHP_FUNCTION(za_wmstate);
PHP_FUNCTION(za_wmtitle);
PHP_FUNCTION(za_wmtransient);
PHP_FUNCTION(za_wmwithdraw);
PHP_FUNCTION(za_write);
PHP_FUNCTION(za_xview);
PHP_FUNCTION(za_xviewmoveto);
PHP_FUNCTION(za_xviewscroll);
PHP_FUNCTION(za_yposition);
PHP_FUNCTION(za_yview);
PHP_FUNCTION(za_yviewmoveto);
PHP_FUNCTION(za_yviewscroll);
/* }}} */

#else
#define phpext_tk_ptr NULL
#endif

/* #endif	HAVE_PTHREAD_LIB */


/*
 * Local variables:
 * tab-width: 4
 * c-basic-offset: 4
 * End:
 */
